/*
 * Decompiled with CFR 0.152.
 */
package org.vanted.addons.gknot;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import org.AttributeHelper;
import org.BackgroundTaskStatusProviderSupportingExternalCall;
import org.FolderPanel;
import org.HomeFolder;
import org.graffiti.editor.MainFrame;
import org.graffiti.editor.MessageType;
import org.graffiti.event.GraphEvent;
import org.graffiti.event.GraphListener;
import org.graffiti.event.TransactionEvent;
import org.graffiti.graph.Edge;
import org.graffiti.graph.Node;
import org.graffiti.plugin.inspector.InspectorTab;
import org.graffiti.plugin.view.View;
import org.graffiti.plugin.view.ViewListener;
import org.graffiti.selection.SelectionEvent;
import org.graffiti.selection.SelectionListener;
import org.graffiti.session.Session;
import org.graffiti.session.SessionListener;
import org.vanted.addons.gknot.AngleHelper;
import org.vanted.addons.gknot.BezierHandling;
import org.vanted.addons.gknot.CreationKnotGraph;
import org.vanted.addons.gknot.Cross2D;
import org.vanted.addons.gknot.DrawKnotAlgorithm;
import org.vanted.addons.gknot.IO;
import org.vanted.addons.gknot.PatternOperations;
import org.vanted.addons.gknot.RenderedView;
import org.vanted.addons.gknot.Spline;
import org.vanted.addons.gknot.SplineGraph;
import org.vanted.addons.gknot.ToolbarButton;

public class AddonTab
extends InspectorTab
implements ViewListener,
SessionListener,
GraphListener,
SelectionListener {
    public static boolean unionMode = false;
    private static final long serialVersionUID = 1L;
    public static ArrayList<Cross2D> cross2DS = new ArrayList();
    static JToggleButton showArms;
    static RenderedView r;
    static JSlider sliderRotation;
    static JSlider sliderLength;
    static JSlider sliderThickness;
    static JTextArea nodeText;
    static FolderPanel fp;
    static FolderPanel fp2;
    static CreationKnotGraph cr1;
    static DrawKnotAlgorithm d;
    static boolean executed;
    static boolean testing;
    JButton download;
    public static JButton execute;
    JButton importGraph;
    JButton exportGraph;
    JButton open;
    JButton nGraph;
    static JButton testUnion;
    JButton edgeContractionOperation;
    JButton addOperation;
    JButton resolveCrossings;
    JButton celticGraph;
    JComboBox<String> choose;
    JFileChooser fileChooser = new JFileChooser();

    public AddonTab() {
        this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {-3.0, 16.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -2.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0}}));
        sliderThickness = new JSlider(0, 5, 50, 20);
        nodeText = new JTextArea();
        showArms = new JToggleButton("Show Arms", false);
        String[] options = new String[]{"Example 1", "Example 2", "Example 3", "Example 4", "Example 5", "Example 6", "Example 7", "Example 8"};
        this.choose = new JComboBox<String>(options);
        this.resolveCrossings = new JButton("Remove Crossings");
        this.resolveCrossings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BezierHandling.resolveCrossings();
            }
        });
        this.celticGraph = new JButton("Straight-Lines");
        this.celticGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CreationKnotGraph.rdg != null) {
                    for (Node n : CreationKnotGraph.rdg.getNodes()) {
                        AttributeHelper.setLabel((Node)n, (String)"");
                        AttributeHelper.setShapeEllipse((Node)n);
                    }
                    for (Edge e1 : CreationKnotGraph.rdg.getEdges()) {
                        AttributeHelper.setArrowhead((Edge)e1, (boolean)false);
                        AttributeHelper.setEdgeBendStyle((Edge)e1, (String)"org.graffiti.plugins.views.defaults.StraightLineEdgeShape");
                    }
                } else {
                    MainFrame.showMessageDialog((String)"Please create a Graph, to change its appearance!", (String)"No Graph to Transform");
                }
            }
        });
        this.edgeContractionOperation = new JButton("Edge Disentanglement 1");
        this.edgeContractionOperation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternOperations.edgeContraction();
            }
        });
        this.addOperation = new JButton("Edge Disentanglement 2");
        this.addOperation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternOperations.edgeSplitting();
            }
        });
        testUnion = new JButton("Enter Combine Mode");
        testUnion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean interfacesInitialized = false;
                if (!unionMode) {
                    unionMode = true;
                    if (AddonTab.isCelticGraph()) {
                        if (CreationKnotGraph.rdg.getNodes().size() > 2) {
                            interfacesInitialized = PatternOperations.scanForInterfaces();
                            if (interfacesInitialized) {
                                if (!DrawKnotAlgorithm.interfaces.get(0).getOuterNodes().isEmpty() && !DrawKnotAlgorithm.interfaces.get(1).getOuterNodes().isEmpty()) {
                                    CreationKnotGraph.selectionMode = true;
                                    CreationKnotGraph.updateColors();
                                    testUnion.setText("Cancel Combine Mode");
                                } else {
                                    CreationKnotGraph.selectionMode = false;
                                    CreationKnotGraph.resetInterfaces();
                                    unionMode = false;
                                    testUnion.setText("Enter Combine Mode");
                                    MainFrame.showMessageDialog((String)"Combine not possible, since there are no vertices with a self loop on the outer face.", (String)"Combine Mode Error");
                                }
                            }
                        } else {
                            CreationKnotGraph.selectionMode = false;
                            CreationKnotGraph.resetInterfaces();
                            unionMode = false;
                            testUnion.setText("Enter Combine Mode");
                            MainFrame.showMessageDialog((String)"Please make sure that every Interface consists of at least 3 vertices.", (String)"Combine Mode Error!");
                        }
                    } else {
                        CreationKnotGraph.selectionMode = false;
                        CreationKnotGraph.resetInterfaces();
                        unionMode = false;
                        testUnion.setText("Enter Combine Mode");
                        MainFrame.showMessageDialog((String)"Please make sure, that all vertices are of degree 4 or of degree 3 with a self-loop.", (String)"Combine Mode Error!");
                    }
                } else {
                    CreationKnotGraph.selectionMode = false;
                    CreationKnotGraph.resetColors();
                    CreationKnotGraph.resetInterfaces();
                    unionMode = false;
                    testUnion.setText("Enter Combine Mode");
                }
            }
        });
        this.nGraph = new JButton("Create Empty");
        this.nGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddonTab.cr1.nodes = new ArrayList();
                AddonTab.cr1.edges = new ArrayList();
                cr1.execute();
                d.reCalculate(nodeText, sliderLength, sliderRotation, false, false, false, false, false, false);
                d.initializeSplineGraph();
                ToolbarButton.setArrangement();
            }
        });
        this.download = new JButton("Download Example Graphs!");
        this.download.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new File(HomeFolder.getHomeFolder() + "/demo").mkdirs();
                String FILE_URL = "https://cloud.uni-konstanz.de/index.php/s/Pa2K6jyqMSWPL63/download/01.gml";
                String output = HomeFolder.getHomeFolder() + "/demo/01.gml";
                AddonTab.this.downloadFile(FILE_URL, output);
                FILE_URL = "https://cloud.uni-konstanz.de/index.php/s/gto3GRRPCXiqnDW/download/02.gml";
                output = HomeFolder.getHomeFolder() + "/demo/02.gml";
                AddonTab.this.downloadFile(FILE_URL, output);
                FILE_URL = "https://cloud.uni-konstanz.de/index.php/s/Zg6cMartCeAr2XE/download/03.gml";
                output = HomeFolder.getHomeFolder() + "/demo/03.gml";
                AddonTab.this.downloadFile(FILE_URL, output);
                FILE_URL = "https://cloud.uni-konstanz.de/index.php/s/Ad54BtcnD2dAAHr/download/04.gml";
                output = HomeFolder.getHomeFolder() + "/demo/04.gml";
                AddonTab.this.downloadFile(FILE_URL, output);
                FILE_URL = "https://cloud.uni-konstanz.de/index.php/s/Gx7x78NoRje82q2/download/05.gml";
                output = HomeFolder.getHomeFolder() + "/demo/05.gml";
                AddonTab.this.downloadFile(FILE_URL, output);
                FILE_URL = "https://cloud.uni-konstanz.de/index.php/s/K8da7K8rPZMGjZz/download/06.gml";
                output = HomeFolder.getHomeFolder() + "/demo/06.gml";
                AddonTab.this.downloadFile(FILE_URL, output);
                FILE_URL = "https://cloud.uni-konstanz.de/index.php/s/Nyd25Kt9nATDTzf/download/07.gml";
                output = HomeFolder.getHomeFolder() + "/demo/07.gml";
                AddonTab.this.downloadFile(FILE_URL, output);
                FILE_URL = "https://cloud.uni-konstanz.de/index.php/s/9bPiWDG87AsjXb3/download/08.gml";
                output = HomeFolder.getHomeFolder() + "/demo/08.gml";
                AddonTab.this.downloadFile(FILE_URL, output);
            }
        });
        this.open = new JButton("Open Example");
        this.open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fName = "";
                switch (AddonTab.this.choose.getSelectedIndex()) {
                    case 0: {
                        fName = HomeFolder.getHomeFolder() + "/demo/01.gml";
                        break;
                    }
                    case 1: {
                        fName = HomeFolder.getHomeFolder() + "/demo/02.gml";
                        break;
                    }
                    case 2: {
                        fName = HomeFolder.getHomeFolder() + "/demo/03.gml";
                        break;
                    }
                    case 3: {
                        fName = HomeFolder.getHomeFolder() + "/demo/04.gml";
                        break;
                    }
                    case 4: {
                        fName = HomeFolder.getHomeFolder() + "/demo/05.gml";
                        break;
                    }
                    case 5: {
                        fName = HomeFolder.getHomeFolder() + "/demo/06.gml";
                        break;
                    }
                    case 6: {
                        fName = HomeFolder.getHomeFolder() + "/demo/07.gml";
                        break;
                    }
                    case 7: {
                        fName = HomeFolder.getHomeFolder() + "/demo/08.gml";
                    }
                }
                try {
                    AddonTab.importGraph(fName);
                    cross2DS.clear();
                    long i = 1L;
                    for (Node n : CreationKnotGraph.rdg.getNodes()) {
                        n.setID(i);
                        ++i;
                    }
                    ArrayList[] a = AddonTab.importGraph(fName);
                    cr1.appendImportGraph(a[0], a[1]);
                    cr1.execute();
                    AddonTab.remodel();
                    ToolbarButton.setArrangement();
                }
                catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
        });
        fp = new FolderPanel("B\u00e9zier Control", false, true, false, null);
        fp.setColumnStyle(140.0, -1.0);
        fp.addGuiComponentRow((JComponent)new JLabel("Thickness:"), (JComponent)sliderThickness, true, 2);
        fp.addGuiComponentRow((JComponent)this.resolveCrossings, (JComponent)this.celticGraph, true, 0);
        fp.setIconSize(FolderPanel.Iconsize.MIDDLE);
        fp.setMaximumRowCount(10);
        this.exportGraph = new JButton("Export for Rendering");
        this.exportGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    IO.exportToKGV();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        this.importGraph = new JButton("Import Graph");
        this.importGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fName = null;
                int retVal = AddonTab.this.fileChooser.showOpenDialog(AddonTab.this.fileChooser);
                if (retVal == 0) {
                    fName = AddonTab.this.fileChooser.getSelectedFile().getAbsoluteFile().getPath();
                }
                if (fName != null) {
                    try {
                        if (fName.contains("gml")) {
                            ArrayList[] a = AddonTab.importGraph(fName);
                            cr1.appendImportGraph(a[0], a[1]);
                            cr1.execute();
                            AddonTab.remodel();
                        }
                        if (fName.contains("kgv")) {
                            AddonTab.this.importKnotGraph(fName);
                        }
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
                ToolbarButton.setArrangement();
            }
        });
        execute = new JButton("Render");
        execute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddonTab.remodel();
            }
        });
        this.nGraph.setToolTipText("Creates a window to draw a new graph.");
        this.importGraph.setToolTipText("Any graph in a .gml format can be used for the import.");
        this.exportGraph.setToolTipText("Celtic Graph gets exported in a .kgv file format, for the import into Blender.");
        this.open.setToolTipText("Imports and renders the above selected example celtic graph.");
        this.download.setToolTipText("Download the example graphs provided. Check from time to time for updates.");
        execute.setToolTipText("Any 4-regular graph can be rendered. Note that a self-loop adds a degree of two to a node.");
        testUnion.setToolTipText("<html> Use this operation to extend a graph with another graph via its outer face.<br><em> Select a set of gray (active) node and a green set to unify the chosen set with.<html>");
        this.edgeContractionOperation.setToolTipText("<html>Use this operation to alter the inner structure of a celtic graph. <br><em>Select two incident edges e1=(n,n1), e2=(n,n2) and the node n they are incident to. <br>Removes e1 and e2 and creates a new edge e3=(n1,n2). If n contained a self loop, it gets deleted.<html> ");
        this.addOperation.setToolTipText("<html>Use this operation to alter the inner structure of a celtic graph or extend the outerface to unify later. <br>Select either: <br> <em>1. A single edge e=(n1,n2), which then gets deleted. Further a new node n is created and two edges connected to n e1=(n1,n), e2=(n2,n).<br><em>2. A single edge e=(n1,n2), which then gets deleted and a node n. Two edges connected to n e1=(n1,n), e2=(n2,n) are created.<html> ");
        this.add(new JLabel("Data-Handling"), "0,3");
        this.add(new JLabel("Pattern Generation"), "0,11");
        this.add(new JSeparator(0), "0,10");
        this.add(new JSeparator(0), "0,15");
        this.add(new JSeparator(0), "0,2");
        this.add(new JLabel("  "), "0,10");
        this.add(new JLabel("  "), "0,2");
        this.add(new JLabel("  "), "0,15");
        this.add(this.importGraph, "0,5");
        this.add(this.exportGraph, "0,6");
        this.add(this.choose, "0,8");
        this.add(this.open, "0,9");
        this.add(this.download, "0,7");
        this.add(this.nGraph, "0,4");
        this.add(execute, "0,16");
        this.add(testUnion, "0,12");
        this.add(this.edgeContractionOperation, "0,13");
        this.add(this.addOperation, "0,14");
        fp.layoutRows();
        this.add((Component)fp, "0,0");
        this.validate();
    }

    public static void remodel() {
        if (AddonTab.isCelticGraph()) {
            cross2DS.clear();
            long i = 1L;
            for (Node n : CreationKnotGraph.rdg.getNodes()) {
                n.setID(i);
                ++i;
            }
            d.reCalculate(nodeText, sliderLength, sliderRotation, false, false, false, false, false, false);
            d.initializeSplineGraph();
            d.reCalcPos(-5.0, 0.0, false);
            d.calculateKGV();
        } else {
            MainFrame.showMessageDialog((String)"Graph is not a celtic Graph, please make sure it consists only of nodes of degree 4 or nodes. Note that a self loop add a degree of two to a node.", (String)"Notice");
            SplineGraph.splines = new ArrayList();
        }
    }

    private static ArrayList[] importGraph(String fName) throws FileNotFoundException {
        ArrayList<String> nodes = new ArrayList<String>();
        ArrayList<String> edges = new ArrayList<String>();
        BufferedReader br = null;
        boolean readingNode = false;
        boolean readingEdge = false;
        try {
            String line;
            StringBuilder oneNode = new StringBuilder();
            StringBuilder oneEdge = new StringBuilder();
            br = new BufferedReader(new FileReader(fName));
            while ((line = br.readLine()) != null) {
                String[] strings;
                if (readingNode) {
                    if (line.contains("id")) {
                        strings = line.split(" ");
                        oneNode.append(strings[5]).append(",");
                    }
                    if (line.startsWith("      x ") || line.startsWith("      y ")) {
                        strings = line.split(" ");
                        oneNode.append(strings[7]).append(",");
                    }
                }
                if (readingEdge && (line.contains("id") || line.contains("source") || line.contains("target"))) {
                    strings = line.split(" ");
                    oneEdge.append(strings[5]).append(",");
                }
                if (line.contains("node")) {
                    readingNode = true;
                }
                if (line.contains("edge")) {
                    readingEdge = true;
                }
                if (readingNode && line.contains("]")) {
                    readingNode = false;
                    nodes.add(String.valueOf(oneNode));
                    oneNode = new StringBuilder();
                }
                if (!readingEdge || !line.contains("]")) continue;
                readingEdge = false;
                edges.add(String.valueOf(oneEdge));
                oneEdge = new StringBuilder();
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList[]{nodes, edges};
    }

    private void downloadFile(String FILE_URL, String output) {
        try (BufferedInputStream in = new BufferedInputStream(new URL(FILE_URL).openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(output);){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
            fileOutputStream.close();
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void importKnotGraph(String fName) throws FileNotFoundException {
        ArrayList<String> nodes = new ArrayList<String>();
        ArrayList<String> edges = new ArrayList<String>();
        ArrayList<String> crosses = new ArrayList<String>();
        ArrayList<String> splines = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(fName));
            boolean readingCrosses = false;
            boolean readingSplines = false;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#Crosses")) {
                    readingCrosses = true;
                    continue;
                }
                if (line.startsWith("#Splines")) {
                    readingCrosses = false;
                    readingSplines = true;
                    continue;
                }
                String[] values = line.split(" ");
                if (readingCrosses) {
                    nodes.add(values[0] + "," + values[1] + "," + values[2]);
                    crosses.add(values[0] + "," + values[3] + "," + values[4] + "," + values[5] + "," + values[6] + "," + values[7]);
                }
                if (!readingSplines) continue;
                edges.add("," + values[0] + "," + values[1] + "," + values[2] + "," + values[3]);
                splines.add(values[0] + "," + values[1] + "," + values[2] + "," + values[3]);
            }
            cr1.appendImportGraph(nodes, edges);
            cr1.execute();
            cross2DS = new ArrayList();
            for (Node n : CreationKnotGraph.rdg.getNodes()) {
                if (n.getDegree() == 4) {
                    cross2DS.add(new Cross2D(AttributeHelper.getPositionX((Node)n), AttributeHelper.getPositionY((Node)n), 20.0, 0.0, n.getID()));
                }
                if (n.getDegree() != 2) continue;
                cross2DS.add(new Cross2D(AttributeHelper.getPositionX((Node)n), AttributeHelper.getPositionY((Node)n), 20.0, 0.0, n.getID()));
            }
            d.reCalculate(nodeText, sliderLength, sliderRotation, false, false, false, false, false, false);
            d.initializeSplineGraph();
            d.reCalcPos(sliderLength.getValue(), sliderRotation.getValue(), false);
            for (Cross2D cross2D : cross2DS) {
                for (String s : crosses) {
                    if (!s.startsWith(String.valueOf(cross2D.getNodeId()))) continue;
                    String[] values = s.split(",");
                    cross2D.setRotation(Double.parseDouble(values[5]));
                    cross2D.resetCrosses();
                }
            }
            SplineGraph.splines = new ArrayList();
            for (String s : splines) {
                String[] values = s.split(",");
                String[] con = new String[]{values[2], values[3]};
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void exportKnotGraph() throws IOException {
        AngleHelper a;
        boolean newCircle = false;
        StringBuilder write = new StringBuilder();
        this.fileChooser = new JFileChooser();
        this.fileChooser.setSelectedFile(new File("Rendering.kgv"));
        this.fileChooser.showSaveDialog(this.fileChooser);
        String fName = this.fileChooser.getSelectedFile().getAbsolutePath();
        FileWriter fileWriter = new FileWriter(fName);
        Cross2D c2 = cross2DS.get(0);
        fileWriter.write("(" + c2.getEndL().x + "," + c2.getEndL().y + ") (" + c2.getXVal() + "," + c2.getYval() + ") (" + c2.getEndR().x + "," + c2.getEndR().y + ")\n");
        String[] input = new String[]{String.valueOf(c2.getNodeId()), "R", "F"};
        while ((input = this.findNextExport(input[1], a = d.searchAngeleHelper(Integer.parseInt(input[0])))) != null) {
            c2 = DrawKnotAlgorithm.searchCross(Integer.parseInt(input[0]));
            switch (input[1]) {
                case "L": {
                    if (input[2].equalsIgnoreCase("T")) {
                        fileWriter.write("* \n");
                    }
                    fileWriter.write("(" + c2.getEndL().x + "," + c2.getEndL().y + ") (" + c2.getXVal() + "," + c2.getYval() + ") (" + c2.getEndR().x + "," + c2.getEndR().y + ")\n");
                    input[1] = "R";
                    break;
                }
                case "T": {
                    if (input[2].equalsIgnoreCase("T")) {
                        fileWriter.write("* \n");
                    }
                    fileWriter.write("(" + c2.getEndT().x + "," + c2.getEndT().y + ") (" + c2.getXVal() + "," + c2.getYval() + ") (" + c2.getEndB().x + "," + c2.getEndB().y + ")\n");
                    input[1] = "B";
                    break;
                }
                case "R": {
                    if (input[2].equalsIgnoreCase("T")) {
                        fileWriter.write("* \n");
                    }
                    fileWriter.write("(" + c2.getEndR().x + "," + c2.getEndR().y + ") (" + c2.getXVal() + "," + c2.getYval() + ") (" + c2.getEndL().x + "," + c2.getEndL().y + ")\n");
                    input[1] = "L";
                    break;
                }
                case "B": {
                    if (input[2].equalsIgnoreCase("T")) {
                        fileWriter.write("* \n");
                    }
                    fileWriter.write("(" + c2.getEndB().x + "," + c2.getEndB().y + ") (" + c2.getXVal() + "," + c2.getYval() + ") (" + c2.getEndT().x + "," + c2.getEndT().y + ")\n");
                    input[1] = "T";
                }
            }
        }
        fileWriter.close();
    }

    private void exportWithSelfLoops() throws IOException {
        FileWriter fileWriter = new FileWriter("fName");
        ArrayList splinesCopy = (ArrayList)SplineGraph.splines.clone();
        Spline loop = (Spline)splinesCopy.get(0);
        Spline next = (Spline)splinesCopy.get(0);
        Cross2D d = loop.getD();
        String[] con = loop.getCon();
        while (!splinesCopy.isEmpty()) {
            this.writeSpline(next, fileWriter);
            splinesCopy.remove(next);
            next = this.searchForSpline(d, con[1]);
            if (next == null) {
                System.out.println("Error in the Algorithm next Spline not found!");
                continue;
            }
            if (next == loop) {
                next = (Spline)splinesCopy.get(0);
            }
            d = next.getC() == d ? next.getD() : next.getC();
            con = next.getCon();
        }
    }

    private Spline searchForSpline(Cross2D d, String con) {
        String con1 = "";
        if (d.isTwoArms()) {
            con1 = con.equalsIgnoreCase("L") ? "T" : "L";
        } else {
            switch (con) {
                case "L": {
                    con1 = "R";
                    break;
                }
                case "T": {
                    con1 = "B";
                    break;
                }
                case "R": {
                    con1 = "L";
                    break;
                }
                case "B": {
                    con1 = "T";
                }
            }
        }
        for (Spline s : SplineGraph.splines) {
            if (s.getC() == d && s.getCon()[0].equalsIgnoreCase(con1)) {
                return s;
            }
            if (s.getD() != d || !s.getCon()[1].equalsIgnoreCase(con1)) continue;
            return s;
        }
        return null;
    }

    private void writeSpline(Spline spline, FileWriter fileWriter) {
        System.out.println(spline.getC().getNodeId() + " to " + spline.getD().getNodeId());
    }

    private String[] findNextExport(String input, AngleHelper angleHelper) {
        int aID = -1;
        double edgeID = -1.0;
        String[] output = new String[2];
        switch (input) {
            case "L": {
                aID = (int)angleHelper.getAngle1()[0];
                edgeID = angleHelper.getAngle1()[2];
                break;
            }
            case "T": {
                aID = (int)angleHelper.getAngle2()[0];
                edgeID = angleHelper.getAngle2()[2];
                break;
            }
            case "R": {
                aID = (int)angleHelper.getAngle3()[0];
                edgeID = angleHelper.getAngle3()[2];
                break;
            }
            case "B": {
                aID = (int)angleHelper.getAngle4()[0];
                edgeID = angleHelper.getAngle4()[2];
            }
        }
        AngleHelper a = null;
        if (aID != -1) {
            a = d.searchAngeleHelper(aID);
        }
        assert (a != null);
        if (a.getAngle1()[2] == edgeID) {
            if (!a.isExportLR()) {
                a.setExportLR(true);
                return new String[]{String.valueOf(aID), "L", "F"};
            }
            return this.searchNonExport();
        }
        if (a.getAngle2()[2] == edgeID) {
            if (!a.isExportTB()) {
                a.setExportTB(true);
                return new String[]{String.valueOf(aID), "T", "F"};
            }
            return this.searchNonExport();
        }
        if (a.getAngle3()[2] == edgeID) {
            if (!a.isExportLR()) {
                a.setExportLR(true);
                return new String[]{String.valueOf(aID), "R", "F"};
            }
            return this.searchNonExport();
        }
        if (a.getAngle4()[2] == edgeID) {
            if (!a.isExportTB()) {
                a.setExportTB(true);
                return new String[]{String.valueOf(aID), "B", "F"};
            }
            return this.searchNonExport();
        }
        return null;
    }

    public static boolean isCelticGraph() {
        if (CreationKnotGraph.rdg != null) {
            for (Node n : CreationKnotGraph.rdg.getNodes()) {
                if (n.getDegree() == 4) continue;
                if (n.getDegree() != 3) {
                    return false;
                }
                if (PatternOperations.containsSelfLoop(n)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private String[] searchNonExport() {
        for (AngleHelper a : DrawKnotAlgorithm.allAngles) {
            if (!a.isExportLR()) {
                return new String[]{String.valueOf(a.getN().getID()), "L", "T"};
            }
            if (a.isExportTB()) continue;
            return new String[]{String.valueOf(a.getN().getID()), "T", "T"};
        }
        return null;
    }

    public String getName() {
        return this.getTitle();
    }

    public String getTitle() {
        return "GKnot";
    }

    public boolean visibleForView(View v) {
        return true;
    }

    public void viewChanged(View newView) {
    }

    public void sessionChanged(Session s) {
    }

    public void sessionDataChanged(Session s) {
    }

    public void postEdgeAdded(GraphEvent e) {
    }

    public void postEdgeRemoved(GraphEvent e) {
    }

    public void postGraphCleared(GraphEvent e) {
    }

    public void postNodeAdded(GraphEvent e) {
        MainFrame.showMessage((String)"Node added!", (MessageType)MessageType.INFO);
    }

    public void postNodeRemoved(GraphEvent e) {
    }

    public void preEdgeAdded(GraphEvent e) {
    }

    public void preEdgeRemoved(GraphEvent e) {
    }

    public void preGraphCleared(GraphEvent e) {
    }

    public void preNodeAdded(GraphEvent e) {
    }

    public void preNodeRemoved(GraphEvent e) {
    }

    public void transactionFinished(TransactionEvent e, BackgroundTaskStatusProviderSupportingExternalCall status) {
    }

    public void transactionStarted(TransactionEvent e) {
    }

    public void selectionChanged(SelectionEvent e) {
    }

    public void selectionListChanged(SelectionEvent e) {
    }

    public boolean isSelectionListener() {
        return true;
    }

    static {
        cr1 = new CreationKnotGraph();
        d = new DrawKnotAlgorithm();
        executed = false;
        testing = false;
    }
}

