/*
 * Decompiled with CFR 0.152.
 */
package org.vanted.addons.gknot;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.AttributeHelper;
import org.graffiti.graph.Node;
import org.vanted.addons.gknot.CreationKnotGraph;
import org.vanted.addons.gknot.PatternOperations;

public class AngleHelper {
    private long iD;
    private final Node n;
    private double[] angle1;
    private double[] angle2;
    private double[] angle3;
    private double[] angle4;
    private boolean finished;
    private double c;
    private boolean exportLR;
    private boolean exportTB;
    private boolean selfLoop;
    private boolean changed;

    public AngleHelper(Node n) {
        this.n = n;
        this.angle1 = null;
        this.angle2 = null;
        this.angle3 = null;
        this.angle4 = null;
        this.finished = false;
        this.c = 0.0;
        this.exportLR = false;
        this.exportTB = false;
        this.changed = false;
        this.iD = n.getID();
    }

    public long getiD() {
        return this.iD;
    }

    public double[] getAngle1() {
        return this.angle1;
    }

    public double[] getAngle2() {
        return this.angle2;
    }

    public double[] getAngle3() {
        return this.angle3;
    }

    public double[] getAngle4() {
        return this.angle4;
    }

    public void setAngle1(double[] angle1) {
        this.angle1 = angle1;
    }

    public void setAngle2(double[] angle2) {
        this.angle2 = angle2;
    }

    public void setAngle3(double[] angle3) {
        this.angle3 = angle3;
    }

    public void setAngle4(double[] angle4) {
        this.angle4 = angle4;
    }

    public Node getN() {
        return this.n;
    }

    public double getAngeleAdjustment() {
        if (this.selfLoop) {
            double cache1 = this.angle3[1] + this.angle4[1];
            double cache2 = -90.0;
            if (this.changed) {
                cache2 = 270.0;
            }
            double phi = 0.5 * (-cache1 + cache2);
            return phi;
        }
        double cache1 = this.angle1[1] + this.angle2[1] + this.angle3[1] + this.angle4[1];
        double cache2 = 179.9;
        double phi = 0.25 * (-cache1 + cache2);
        return phi + this.c;
    }

    public String getCon(long e) {
        if (e == (long)this.angle1[2]) {
            return "L";
        }
        if ((long)this.angle2[2] == e) {
            return "T";
        }
        if ((long)this.angle3[2] == e) {
            return "R";
        }
        if ((long)this.angle4[2] == e) {
            return "B";
        }
        return null;
    }

    public void cycleOrder() {
        if (this.getAngle4() == null) {
            return;
        }
        double[] a1 = (double[])this.angle1.clone();
        double[] a2 = (double[])this.angle2.clone();
        double[] a3 = (double[])this.angle3.clone();
        double[] a4 = (double[])this.angle4.clone();
        this.c -= 90.0;
        this.angle1 = a4;
        this.angle2 = a1;
        this.angle3 = a2;
        this.angle4 = a3;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean isExportLR() {
        return this.exportLR;
    }

    public boolean isExportTB() {
        return this.exportTB;
    }

    public void setExportLR(boolean exportLR) {
        this.exportLR = exportLR;
    }

    public void setExportTB(boolean exportTB) {
        this.exportTB = exportTB;
    }

    public void setSelfLoop(boolean selfLoop) {
        this.selfLoop = selfLoop;
    }

    public boolean isSelfLoop() {
        return this.selfLoop;
    }

    public void selfLoopOrder2() {
        ArrayList<Node> neigbours = new ArrayList<Node>();
        for (Node m : this.n.getNeighbors()) {
            if (this.n == m) continue;
            neigbours.add(m);
        }
        Node n2 = this.searchNode(this.angle3[0]);
        Node n3 = this.searchNode(this.angle4[0]);
        Point2D.Double p1 = new Point2D.Double(AttributeHelper.getPositionX((Node)this.n), AttributeHelper.getPositionY((Node)this.n));
        assert (n2 != null);
        Point2D.Double p2 = new Point2D.Double(AttributeHelper.getPositionX((Node)n2), AttributeHelper.getPositionY((Node)n2));
        assert (n3 != null);
        Point2D.Double p3 = new Point2D.Double(AttributeHelper.getPositionX((Node)n3), AttributeHelper.getPositionY((Node)n3));
        double slopeP1P2 = AngleHelper.getSlope2(p1, p2);
        double slopeP1P3 = AngleHelper.getSlope2(p1, p3);
        double beta = Math.toDegrees(PatternOperations.angleBetween2Lines(new Line2D.Double(((Point2D)p1).getX(), ((Point2D)p1).getY(), ((Point2D)p2).getX(), ((Point2D)p2).getY()), new Line2D.Double(((Point2D)p1).getX(), ((Point2D)p1).getY(), ((Point2D)p3).getX(), ((Point2D)p3).getY())));
        if (beta >= 0.0 && beta <= 180.0) {
            double[] cacheC = (double[])this.angle3.clone();
            this.angle3 = (double[])this.angle4.clone();
            this.angle4 = cacheC;
            this.changed = true;
        }
    }

    public void selfLoopOrder() {
        this.changed = false;
        Node n = this.n;
        Node c = this.searchNode(this.angle3[0]);
        Node d = this.searchNode(this.angle4[0]);
        Point2D.Double p1 = new Point2D.Double(AttributeHelper.getPositionX((Node)n), AttributeHelper.getPositionY((Node)n));
        Point2D.Double p2 = new Point2D.Double(AttributeHelper.getPositionX((Node)c), AttributeHelper.getPositionY((Node)c));
        Point2D.Double p3 = new Point2D.Double(AttributeHelper.getPositionX((Node)d), AttributeHelper.getPositionY((Node)d));
        int quadrantP2 = AngleHelper.determineRotatedQuadrant(p2, p1, 45.0);
        int quadrantP3 = AngleHelper.determineRotatedQuadrant(p3, p1, 45.0);
        if (quadrantP2 == 4 && quadrantP3 == 3 || quadrantP2 == 3 && quadrantP3 == 2) {
            double[] cacheC = (double[])this.angle3.clone();
            this.angle3 = (double[])this.angle4.clone();
            this.angle4 = cacheC;
            this.changed = true;
        }
    }

    private Node searchNode(double id) {
        for (Node n : CreationKnotGraph.rdg.getNodes()) {
            if (n.getID() != (long)id) continue;
            return n;
        }
        return null;
    }

    private static double getSlope2(Point2D point1, Point2D point2) {
        return (point2.getY() - point1.getY()) / (point2.getX() - point1.getX());
    }

    private static int determineRotatedQuadrant2(Point2D point, Point2D pivot, double rotationAngle) {
        double xDiff = point.getX() - pivot.getX();
        double yDiff = point.getY() - pivot.getY();
        double rotatedX = Math.cos(rotationAngle) * xDiff - Math.sin(rotationAngle) * yDiff;
        double rotatedY = Math.sin(rotationAngle) * xDiff + Math.cos(rotationAngle) * yDiff;
        if (rotatedX > 0.0 && rotatedY > 0.0) {
            return 1;
        }
        if (rotatedX < 0.0 && rotatedY > 0.0) {
            return 2;
        }
        if (rotatedX < 0.0 && rotatedY < 0.0) {
            return 3;
        }
        if (rotatedX > 0.0 && rotatedY < 0.0) {
            return 4;
        }
        return 0;
    }

    private static int determineRotatedQuadrant(Point2D point, Point2D pivot, double rotationAngle) {
        double xDiff = point.getX() - pivot.getX();
        double yDiff = point.getY() - pivot.getY();
        double rotatedX = Math.cos(rotationAngle) * xDiff - Math.sin(rotationAngle) * yDiff;
        double rotatedY = Math.sin(rotationAngle) * xDiff + Math.cos(rotationAngle) * yDiff;
        if (rotatedX > 0.0 && rotatedY > 0.0) {
            return 1;
        }
        if (rotatedX < 0.0 && rotatedY > 0.0) {
            return 2;
        }
        if (rotatedX < 0.0 && rotatedY < 0.0) {
            return 3;
        }
        if (rotatedX > 0.0 && rotatedY < 0.0) {
            return 4;
        }
        return 0;
    }

    private static double getSlope(Point2D point1, Point2D point2) {
        return (point2.getY() - point1.getY()) / (point2.getX() - point1.getX());
    }

    private static int determineQuadrant(Point2D point, double slope) {
        double x = point.getX();
        double y = point.getY();
        if (x > 0.0 && y > 0.0) {
            return slope > 0.0 ? 1 : 4;
        }
        if (x < 0.0 && y > 0.0) {
            return slope > 0.0 ? 2 : 3;
        }
        if (x < 0.0 && y < 0.0) {
            return slope > 0.0 ? 3 : 2;
        }
        if (x > 0.0 && y < 0.0) {
            return slope > 0.0 ? 4 : 1;
        }
        return 0;
    }
}

