/*
 * Decompiled with CFR 0.152.
 */
package org.vanted.addons.gknot;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.graffiti.editor.MainFrame;
import org.vanted.addons.gknot.Spline;
import org.vanted.addons.gknot.SplineGraph;

public class BezierHandling {
    private static final int lineSegments = 100;
    private static final double tolerance = 1.0E-4;

    public static Point2D[] calculateMinimumCurvature(Point2D[] controlPoints) {
        double globalMinKappa = Double.MAX_VALUE;
        while (true) {
            double currentMinKappa = BezierHandling.getMaxKappa(controlPoints);
            double currentDistance = BezierHandling.armLength(controlPoints);
            if (currentMinKappa >= globalMinKappa || currentDistance > 300.0) break;
            globalMinKappa = currentMinKappa;
            controlPoints = BezierHandling.increaseControlPoints(controlPoints);
        }
        return controlPoints;
    }

    private static double getMaxKappa(Point2D[] controlPoints) {
        double increase;
        double maxKappa = 0.0;
        for (double t = 0.0; t < 1.0; t += increase) {
            double kappa = BezierHandling.calculateKappa(controlPoints, t);
            if (kappa > maxKappa) {
                maxKappa = kappa;
            }
            increase = 0.001;
        }
        if (maxKappa == 0.0) {
            return 0.01;
        }
        return maxKappa;
    }

    private static double calculateKappa(Point2D[] points, double t) {
        double xDot = BezierHandling.calculateXDot(points, t);
        double yDot = BezierHandling.calculateYDot(points, t);
        double xDotDot = BezierHandling.calculateXDotDot(points, t);
        double yDotDot = BezierHandling.calculateYDotDot(points, t);
        double numerator = xDot * yDotDot - yDot * xDotDot;
        double denominator = Math.pow(xDot * xDot + yDot * yDot, 1.5);
        if (Math.abs(denominator) < 1.0E-4) {
            return 0.0;
        }
        return Math.abs(numerator / denominator);
    }

    private static double calculateXDot(Point2D[] points, double t) {
        return (-3.0 + 6.0 * t - 3.0 * t * t) * points[0].getX() + 3.0 * (1.0 - 4.0 * t + 3.0 * t * t) * points[1].getX() + 3.0 * (2.0 * t - 3.0 * t * t) * points[2].getX() + 3.0 * t * t * points[3].getX();
    }

    private static double calculateYDot(Point2D[] points, double t) {
        return (-3.0 + 6.0 * t - 3.0 * t * t) * points[0].getY() + 3.0 * (1.0 - 4.0 * t + 3.0 * t * t) * points[1].getY() + 3.0 * (2.0 * t - 3.0 * t * t) * points[2].getY() + 3.0 * t * t * points[3].getY();
    }

    private static double calculateXDotDot(Point2D[] points, double t) {
        return 6.0 * (1.0 - t) * points[0].getX() + 3.0 * (-4.0 + 6.0 * t) * points[1].getX() + 3.0 * (2.0 - 6.0 * t) * points[2].getX() + 6.0 * t * points[3].getX();
    }

    private static double calculateYDotDot(Point2D[] points, double t) {
        return 6.0 * (1.0 - t) * points[0].getY() + 3.0 * (-4.0 + 6.0 * t) * points[1].getY() + 3.0 * (2.0 - 6.0 * t) * points[2].getY() + 6.0 * t * points[3].getY();
    }

    private static Point2D[] increaseControlPoints(Point2D[] points) {
        Point2D[] newPoints = new Point2D[4];
        double x0 = points[0].getX();
        double y0 = points[0].getY();
        double x1 = points[1].getX();
        double y1 = points[1].getY();
        double x2 = points[2].getX();
        double y2 = points[2].getY();
        double x3 = points[3].getX();
        double y3 = points[3].getY();
        Point2D.Double newP1 = new Point2D.Double(x0 + (x1 - x0) * 1.1, y0 + (y1 - y0) * 1.1);
        Point2D.Double newP2 = new Point2D.Double(x3 + (x2 - x3) * 1.1, y3 + (y2 - y3) * 1.1);
        newPoints[0] = new Point2D.Double(x0, y0);
        newPoints[1] = newP1;
        newPoints[2] = newP2;
        newPoints[3] = new Point2D.Double(x3, y3);
        return newPoints;
    }

    private static void reduceControlPoints(Spline p, Spline q) {
        double minFactor = 0.95;
        double x0P = p.getX0();
        double y0P = p.getY0();
        double x1P = p.getX1();
        double y1P = p.getY1();
        double x2P = p.getX2();
        double y2P = p.getY2();
        double x3P = p.getX3();
        double y3P = p.getY3();
        p.setX1(x0P + (x1P - x0P) * minFactor);
        p.setY1(y0P + (y1P - y0P) * minFactor);
        p.setX2(x3P + (x2P - x3P) * minFactor);
        p.setY2(y3P + (y2P - y3P) * minFactor);
        double x0Q = q.getX0();
        double y0Q = q.getY0();
        double x1Q = q.getX1();
        double y1Q = q.getY1();
        double x2Q = q.getX2();
        double y2Q = q.getY2();
        double x3Q = q.getX3();
        double y3Q = q.getY3();
        q.setX1(x0Q + (x1Q - x0Q) * minFactor);
        q.setY1(y0Q + (y1Q - y0Q) * minFactor);
        q.setX2(x3Q + (x2Q - x3Q) * minFactor);
        q.setY2(y3Q + (y2Q - y3Q) * minFactor);
    }

    public static void resolveCrossings() {
        double distanceControlBezier = 1.0;
        for (int i = 0; i < SplineGraph.splines.size(); ++i) {
            block1: for (int j = i + 1; j < SplineGraph.splines.size(); ++j) {
                Spline splineP = SplineGraph.splines.get(i);
                Spline splineQ = SplineGraph.splines.get(j);
                if (!splineP.getSpline().getBounds2D().intersects(splineQ.getSpline().getBounds2D())) continue;
                Line2D minDistance = BezierHandling.minimumDistanceBezier2Bezier(splineP, splineQ);
                int control = 0;
                while (BezierHandling.length(minDistance) < distanceControlBezier) {
                    if (control > 200) {
                        MainFrame.showMessageDialog((String)"Crossing could not be resolved entirely.", (String)"Crossing Error!");
                        continue block1;
                    }
                    System.out.println(splineP.getC().getNodeId() + " to " + splineP.getD().getNodeId() + ", and: " + splineQ.getC().getNodeId() + " to " + splineQ.getD().getNodeId());
                    BezierHandling.reduceControlPoints(splineP, splineQ);
                    minDistance = BezierHandling.minimumDistanceBezier2Bezier(splineP, splineQ);
                    System.out.println(BezierHandling.length(minDistance));
                    ++control;
                }
            }
        }
    }

    private static Line2D minimumDistanceBezier2Bezier(Spline p, Spline q) {
        double[] tRange = new double[]{0.009, 0.991};
        double[] sRange = new double[]{0.009, 0.991};
        double epsilon = 0.001;
        Point2D qMin = new Point2D.Double();
        new Point2D.Double();
        Point2D pMinMin = new Point2D.Double(0.0, 0.0);
        double minMin = Double.MAX_VALUE;
        for (double s = sRange[0] - 1.0E-4; s < sRange[1] + 1.0E-4; s += epsilon) {
            double tMin;
            Point2D pMin;
            Point2D qs = BezierHandling.getBezierPoint(q, s);
            double d = qs.distance(pMin = BezierHandling.getBezierPoint(p, tMin = BezierHandling.minimumDistancePoint2Bezier(qs, p, tRange)));
            if (!(d < minMin)) continue;
            minMin = d;
            qMin = qs;
            pMinMin = pMin;
        }
        return new Line2D.Double(pMinMin, qMin);
    }

    private static double length(Line2D segment) {
        double x = segment.getX1() - segment.getX2();
        double y = segment.getY1() - segment.getY2();
        return Math.sqrt(x * x + y * y);
    }

    private static Point2D getBezierPoint(Spline spline, double t) {
        double v = 1.0 - 3.0 * t + 3.0 * t * t - t * t * t;
        double v1 = t - 2.0 * t * t + t * t * t;
        double x = v * spline.getX0() + 3.0 * v1 * spline.getX1() + 3.0 * (t * t - t * t * t) * spline.getX2() + t * t * t * spline.getX3();
        double y = v * spline.getY0() + 3.0 * v1 * spline.getY1() + 3.0 * (t * t - t * t * t) * spline.getY2() + t * t * t * spline.getY3();
        return new Point2D.Double(x, y);
    }

    private static double minimumDistancePoint2Bezier(Point2D qs, Spline p, double[] tRange) {
        double epsilon = 0.001;
        double min = Double.MAX_VALUE;
        double tMin = 0.0;
        for (double t = tRange[0] - 1.0E-4; t < tRange[1] + 1.0E-4; t += epsilon) {
            Point2D pt = BezierHandling.getBezierPoint(p, t);
            double d = pt.distance(qs);
            if (!(d < min)) continue;
            min = d;
            tMin = t;
        }
        return tMin;
    }

    private static double armLength(Point2D[] controlPoints) {
        return controlPoints[0].distance(controlPoints[1]);
    }
}

