/*
 * Decompiled with CFR 0.152.
 */
package org.vanted.addons.gknot;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.AttributeHelper;
import org.Vector2d;
import org.graffiti.graph.Node;
import org.vanted.addons.gknot.ConvexHull;
import org.vanted.addons.gknot.CreationKnotGraph;
import org.vanted.addons.gknot.DrawKnotAlgorithm;
import org.vanted.addons.gknot.PatternOperations;

public class CInterface {
    private long id;
    private final ArrayList<Node> innerNodes;
    private ArrayList<Node> outerNodes;
    private final ArrayList<long[]> replacementNodes;
    public ArrayList<ArrayList<Node>> unionNodes;
    private Vector2d centroid;
    private final ArrayList<Node> convexHull;
    private final ArrayList<CInterface> interfaces = new ArrayList();

    public CInterface(List<Node> nodes) {
        this.innerNodes = new ArrayList();
        this.outerNodes = new ArrayList();
        this.getInnerOuterNodes(nodes);
        this.replacementNodes = new ArrayList();
        this.getReplacementNodes();
        this.convexHull = ConvexHull.convexHull(nodes.toArray(new Node[0]));
        this.calculateCentroid();
    }

    private void getInnerOuterNodes(List<Node> nodes) {
        Node[] nodesArray = nodes.toArray(new Node[0]);
        ArrayList<Node> convexHull = ConvexHull.convexHull(nodesArray);
        if (convexHull != null) {
            for (Node n : convexHull) {
                if (this.isUNode(n)) {
                    this.outerNodes.add(n);
                    continue;
                }
                this.innerNodes.add(n);
            }
            for (Node n : nodes) {
                if (convexHull.contains(n)) continue;
                this.innerNodes.add(n);
            }
        } else {
            this.outerNodes = null;
        }
        assert (convexHull != null);
        this.pointsOnConvexHull(convexHull);
        this.getUnionNodes(convexHull);
    }

    private void getUnionNodes(ArrayList<Node> convexHull) {
        this.unionNodes = new ArrayList();
        for (int i = 0; i < convexHull.size(); ++i) {
            Node m;
            Node n;
            ArrayList currentSelection = new ArrayList();
            if (i == convexHull.size() - 1) {
                n = convexHull.get(i);
                m = convexHull.get(0);
            } else {
                n = convexHull.get(i);
                m = convexHull.get(i + 1);
            }
            if (this.searchNodesOnLine(n, m, convexHull) == null) continue;
            this.unionNodes.add(this.searchNodesOnLine(n, m, convexHull));
        }
        for (ArrayList<Node> a : this.unionNodes) {
            System.out.println("THIS");
            System.out.println(a);
        }
    }

    private void pointsOnConvexHull(ArrayList<Node> convexHull) {
        for (int i = 0; i < convexHull.size(); ++i) {
            Node m;
            Node n;
            if (i == convexHull.size() - 1) {
                n = convexHull.get(i);
                m = convexHull.get(0);
            } else {
                n = convexHull.get(i);
                m = convexHull.get(i + 1);
            }
            this.searchNodesOnLine(n, m);
        }
    }

    private ArrayList<Node> searchNodesOnLine(Node n, Node m, ArrayList<Node> convexHull) {
        ArrayList<Node> currentSelection = new ArrayList<Node>();
        if (!this.isUNode(n) || !this.isUNode(m)) {
            return null;
        }
        currentSelection.add(n);
        currentSelection.add(m);
        double tolerance = 30.0;
        Line2D.Double line = new Line2D.Double(AttributeHelper.getPositionX((Node)n), AttributeHelper.getPositionY((Node)n), AttributeHelper.getPositionX((Node)m), AttributeHelper.getPositionY((Node)m));
        for (Node o : this.getOuterNodes()) {
            Point2D.Double p = new Point2D.Double(AttributeHelper.getPositionX((Node)o), AttributeHelper.getPositionY((Node)o));
            if (!(line.ptLineDist(p) < tolerance) || n.getID() == o.getID() || m.getID() == o.getID()) continue;
            if (!this.isUNode(o)) {
                return null;
            }
            currentSelection.add(o);
        }
        return currentSelection;
    }

    private void searchNodesOnLine(Node n, Node m) {
        Line2D.Double line = new Line2D.Double(AttributeHelper.getPositionX((Node)n), AttributeHelper.getPositionY((Node)n), AttributeHelper.getPositionX((Node)m), AttributeHelper.getPositionY((Node)m));
        for (Node o : CreationKnotGraph.rdg.getNodes()) {
            Point2D.Double p = new Point2D.Double(AttributeHelper.getPositionX((Node)o), AttributeHelper.getPositionY((Node)o));
            if (!line.intersects(((Point2D)p).getX(), ((Point2D)p).getY(), 3.0, 3.0) || this.outerNodes.contains(o) || !this.isUNode(o)) continue;
            this.outerNodes.add(o);
        }
    }

    private void getReplacementNodes() {
        for (CInterface i : this.interfaces) {
            for (Node n : i.outerNodes) {
                this.replacementNodes.add(new long[]{i.id, n.getID()});
            }
        }
    }

    public void calculateCentroid() {
        ArrayList<Node> convexHull = this.getConvexHull();
        double sumX = 0.0;
        double sumY = 0.0;
        double n1 = convexHull.size();
        for (Node n : convexHull) {
            sumX += AttributeHelper.getPositionX((Node)n);
            sumY += AttributeHelper.getPositionY((Node)n);
        }
        this.centroid = new Vector2d(1.0 / n1 * sumX, 1.0 / n1 * sumY);
    }

    public ArrayList<ArrayList<Node>> getMatchesRight(int size) {
        ArrayList<ArrayList<Node>> matches = new ArrayList<ArrayList<Node>>();
        if (size == 1) {
            for (Node n : DrawKnotAlgorithm.interfaces.get(1).getOuterNodes()) {
                ArrayList<Node> toAdd = new ArrayList<Node>();
                toAdd.add(n);
                matches.add(toAdd);
            }
            return matches;
        }
        return matches;
    }

    public ArrayList<Node> getMatchesLeft() {
        ArrayList<Node> matches = new ArrayList<Node>();
        for (ArrayList<Node> m : this.unionNodes) {
            if (CreationKnotGraph.currentSelection1.size() >= m.size() || !m.containsAll(CreationKnotGraph.currentSelection1)) continue;
            for (Node n : m) {
                if (CreationKnotGraph.currentSelection1.contains(n)) continue;
                matches.add(n);
            }
        }
        return matches;
    }

    public Vector2d getCentroid() {
        return this.centroid;
    }

    public ArrayList<Node> getOuterNodes() {
        return this.outerNodes;
    }

    public ArrayList<Node> getInnerNodes() {
        return this.innerNodes;
    }

    public long getId() {
        return this.id;
    }

    public ArrayList<Node> getConvexHull() {
        return this.convexHull;
    }

    public boolean isUNode(Node n) {
        if (n.getDegree() == 3) {
            return PatternOperations.containsSelfLoop(n);
        }
        return false;
    }

    public ArrayList<ArrayList<Node>> getAllUnionNodes() {
        return this.unionNodes;
    }
}

