/*
 * Decompiled with CFR 0.152.
 */
package org.vanted.addons.gknot;

import de.ipk_gatersleben.ag_nw.graffiti.GraphHelper;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.AttributeHelper;
import org.BackgroundTaskStatusProviderSupportingExternalCall;
import org.ErrorMsg;
import org.PositionGridGenerator;
import org.Vector2d;
import org.graffiti.attributes.Attributable;
import org.graffiti.editor.GravistoService;
import org.graffiti.editor.LoadSetting;
import org.graffiti.event.GraphEvent;
import org.graffiti.event.GraphListener;
import org.graffiti.event.NodeEvent;
import org.graffiti.event.NodeListener;
import org.graffiti.event.TransactionEvent;
import org.graffiti.graph.AdjListGraph;
import org.graffiti.graph.Edge;
import org.graffiti.graph.Graph;
import org.graffiti.graph.Node;
import org.graffiti.plugin.algorithm.AbstractAlgorithm;
import org.graffiti.plugin.algorithm.Category;
import org.graffiti.plugin.algorithm.PreconditionException;
import org.graffiti.session.EditorSession;
import org.vanted.addons.gknot.AddonTab;
import org.vanted.addons.gknot.Cross2D;
import org.vanted.addons.gknot.DrawKnotAlgorithm;
import org.vanted.addons.gknot.SplineGraph;
import org.vanted.addons.gknot.UnionOfInterfaces;

public class CreationKnotGraph
extends AbstractAlgorithm {
    public static Graph rdg = new AdjListGraph();
    public static EditorSession es;
    public static List<Edge> removedEdge;
    public ArrayList<String> nodes;
    public ArrayList<String> edges;
    public static ArrayList<Edge> indicatorEdges;
    public static boolean selectionMode;
    public static boolean extended;
    public static ArrayList<Node> currentSelection1;
    public static ArrayList<Node> currentSelection2;
    public static ArrayList<Line2D> unionSelection1;
    public static ArrayList<Line2D> unionSelection2;
    private static final MouseMotionListener execButton;
    private static final MouseListener unionSelectingNodes;

    public static void checkRenderButton() {
        try {
            if (!AddonTab.isCelticGraph()) {
                AddonTab.execute.setForeground(Color.lightGray);
            } else {
                AddonTab.execute.setForeground(Color.BLACK);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static ArrayList<Node> getUnionSelectionEdge(double x, double y, double d, Edge e) {
        Line2D.Double line = new Line2D.Double(AttributeHelper.getPositionX((Node)e.getSource()), AttributeHelper.getPositionY((Node)e.getSource()), AttributeHelper.getPositionX((Node)e.getTarget()), AttributeHelper.getPositionY((Node)e.getTarget()));
        if (line.intersects(x, y, d, d)) {
            for (ArrayList<Node> nodes : DrawKnotAlgorithm.interfaces.get((int)1).unionNodes) {
                if (!nodes.contains(e.getSource()) || !nodes.contains(e.getTarget())) continue;
                return nodes;
            }
        }
        return null;
    }

    private static ArrayList<Node> getUnionSelection2(double x, double y, double d, Node n) {
        Ellipse2D.Double circle = new Ellipse2D.Double(AttributeHelper.getPositionX((Node)n), AttributeHelper.getPositionY((Node)n), d, d);
        if (circle.intersects(x, y, d, d)) {
            for (ArrayList<Node> rightSet : DrawKnotAlgorithm.interfaces.get(1).getMatchesRight(currentSelection1.size())) {
                if (!rightSet.contains(n) || rightSet.size() != currentSelection1.size()) continue;
                return rightSet;
            }
        }
        return null;
    }

    private static void extendSelection(double x, double y, double d, Node n, ArrayList<Node> currentSelection) {
        Ellipse2D.Double circle = new Ellipse2D.Double(AttributeHelper.getPositionX((Node)n), AttributeHelper.getPositionY((Node)n), d, d);
        if (circle.intersects(x, y, d, d)) {
            if (currentSelection.contains(n)) {
                currentSelection.remove(n);
            } else if (DrawKnotAlgorithm.interfaces.get(0).getMatchesLeft().contains(n)) {
                currentSelection.add(n);
            } else {
                System.out.println("No Match");
            }
            extended = true;
            CreationKnotGraph.fastRedraw1();
        }
        if (currentSelection1.size() > 1) {
            ArrayList<Line2D> updateLines1 = new ArrayList<Line2D>();
            ArrayList<Line2D> updateLines2 = new ArrayList<Line2D>();
            CreationKnotGraph.updateLines(updateLines1, currentSelection1);
            for (ArrayList<Node> s2N : DrawKnotAlgorithm.interfaces.get(1).getMatchesRight(currentSelection1.size())) {
                CreationKnotGraph.updateLines(updateLines2, s2N);
            }
            unionSelection1 = updateLines1;
            unionSelection2 = updateLines2;
        }
    }

    private static void updateLines(ArrayList<Line2D> updateLines2, ArrayList<Node> s2N) {
        for (int i = 0; i < s2N.size() - 1; ++i) {
            updateLines2.add(new Line2D.Double(AttributeHelper.getPositionX((Node)s2N.get(i)), AttributeHelper.getPositionY((Node)s2N.get(i)), AttributeHelper.getPositionX((Node)s2N.get(i + 1)), AttributeHelper.getPositionY((Node)s2N.get(i + 1))));
        }
    }

    public static void resetColors() {
        for (Node n : DrawKnotAlgorithm.interfaces.get(0).getOuterNodes()) {
            AttributeHelper.setFillColor((Attributable)n, (Color)Color.WHITE);
        }
        for (Node n : DrawKnotAlgorithm.interfaces.get(0).getInnerNodes()) {
            AttributeHelper.setFillColor((Attributable)n, (Color)Color.WHITE);
        }
        for (Node n : DrawKnotAlgorithm.interfaces.get(1).getOuterNodes()) {
            AttributeHelper.setFillColor((Attributable)n, (Color)Color.WHITE);
        }
        for (Node n : DrawKnotAlgorithm.interfaces.get(1).getInnerNodes()) {
            AttributeHelper.setFillColor((Attributable)n, (Color)Color.WHITE);
        }
    }

    public static void updateColors() {
        if (currentSelection1.isEmpty()) {
            for (Node node : DrawKnotAlgorithm.interfaces.get(0).getOuterNodes()) {
                AttributeHelper.setFillColor((Attributable)node, (Color)Color.decode("#D3D3D3"));
            }
            for (Node node : DrawKnotAlgorithm.interfaces.get(1).getOuterNodes()) {
                AttributeHelper.setFillColor((Attributable)node, (Color)Color.white);
            }
            for (Node node : DrawKnotAlgorithm.interfaces.get(1).getInnerNodes()) {
                AttributeHelper.setFillColor((Attributable)node, (Color)Color.white);
            }
        } else {
            for (Node node : DrawKnotAlgorithm.interfaces.get(0).getOuterNodes()) {
                AttributeHelper.setFillColor((Attributable)node, (Color)Color.white);
            }
            for (Node node : currentSelection1) {
                AttributeHelper.setFillColor((Attributable)node, (Color)Color.GREEN);
            }
            for (Node node : DrawKnotAlgorithm.interfaces.get(0).getMatchesLeft()) {
                AttributeHelper.setFillColor((Attributable)node, (Color)Color.decode("#D3D3D3"));
            }
            if (currentSelection1.size() == 1) {
                CreationKnotGraph.deleteIndicatorEdges();
                for (Node node : DrawKnotAlgorithm.interfaces.get(1).getOuterNodes()) {
                    AttributeHelper.setFillColor((Attributable)node, (Color)Color.white);
                }
                for (Node node : DrawKnotAlgorithm.interfaces.get(1).getInnerNodes()) {
                    AttributeHelper.setFillColor((Attributable)node, (Color)Color.white);
                }
                for (ArrayList arrayList : DrawKnotAlgorithm.interfaces.get(1).getMatchesRight(currentSelection1.size())) {
                    for (Node n : arrayList) {
                        AttributeHelper.setFillColor((Attributable)n, (Color)Color.decode("#84fa84"));
                    }
                }
            } else {
                CreationKnotGraph.deleteIndicatorEdges();
                for (Node node : DrawKnotAlgorithm.interfaces.get(1).getOuterNodes()) {
                    AttributeHelper.setFillColor((Attributable)node, (Color)Color.white);
                }
                for (Node node : DrawKnotAlgorithm.interfaces.get(1).getInnerNodes()) {
                    AttributeHelper.setFillColor((Attributable)node, (Color)Color.white);
                }
                for (ArrayList arrayList : DrawKnotAlgorithm.interfaces.get((int)1).unionNodes) {
                    if (arrayList.size() != currentSelection1.size()) continue;
                    Node[] toConnect = CreationKnotGraph.orderNodes(arrayList);
                    Edge e = rdg.addEdge(toConnect[0], toConnect[1], false);
                    indicatorEdges.add(e);
                    AttributeHelper.setBorderWidth((Edge)e, (double)3.0);
                    AttributeHelper.setOutlineColor((Attributable)e, (Color)Color.decode("#84fa84"));
                    AttributeHelper.setArrowhead((Edge)e, (boolean)false);
                    CreationKnotGraph.fastRedraw1();
                }
            }
        }
    }

    public static void deleteIndicatorEdges() {
        for (Edge e : indicatorEdges) {
            rdg.deleteEdge(e);
            CreationKnotGraph.fastRedraw1();
        }
        indicatorEdges = new ArrayList();
    }

    private static Node[] orderNodes(ArrayList<Node> nodes) {
        Node n1 = null;
        Node n2 = null;
        double maxDistance = Double.MIN_VALUE;
        for (int i = 0; i < nodes.size() - 1; ++i) {
            for (int j = 1; j < nodes.size(); ++j) {
                Point2D.Double p2;
                Point2D.Double p1 = new Point2D.Double(AttributeHelper.getPositionX((Node)nodes.get(i)), AttributeHelper.getPositionY((Node)nodes.get(i)));
                double currentDistance = p1.distance(p2 = new Point2D.Double(AttributeHelper.getPositionX((Node)nodes.get(j)), AttributeHelper.getPositionY((Node)nodes.get(j))));
                if (!(currentDistance >= maxDistance)) continue;
                n1 = nodes.get(i);
                n2 = nodes.get(j);
                maxDistance = currentDistance;
            }
        }
        return new Node[]{n1, n2};
    }

    public static void resetInterfaces() {
        CreationKnotGraph.deleteIndicatorEdges();
        currentSelection1 = new ArrayList();
        currentSelection1 = new ArrayList();
        DrawKnotAlgorithm.interfaces = new ArrayList();
    }

    public void check() throws PreconditionException {
        super.check();
    }

    public String getCategory() {
        return null;
    }

    public Set<Category> getSetCategory() {
        return new HashSet<Category>(Arrays.asList(Category.GRAPH, Category.COMPUTATION));
    }

    public String getName() {
        return "Generate 4-complete Knot-Graph";
    }

    public String getDescription() {
        return "<html>Create a 4-complete Graph with a rendered view of its knot representation";
    }

    public void appendImportGraph(ArrayList<String> nodes, ArrayList<String> edges) {
        this.nodes = nodes;
        this.edges = edges;
    }

    public void execute() {
        try {
            boolean randomGraph = false;
            if (this.nodes != null) {
                rdg = CreationKnotGraph.createGraph(this.nodes, this.edges);
            }
            es = new EditorSession(rdg);
            this.nodes = null;
            this.edges = null;
            try {
                es.setFileName(rdg.getName(true));
            }
            catch (Exception err) {
                ErrorMsg.addErrorMessage((Exception)err);
            }
            GravistoService.getInstance().getMainFrame().showViewChooserDialog(es, false, new ActionEvent((Object)this, 1, this.getName()), LoadSetting.VIEW_CHOOSER_FOR_LARGE_GRAPHS_ONLY);
            GraphHelper.issueCompleteRedrawForActiveView();
            es.getActiveView().getViewComponent().addMouseListener(unionSelectingNodes);
            es.getActiveView().getViewComponent().addMouseMotionListener(execButton);
            es.getGraph().getListenerManager().addDelayedNodeListener(new NodeListener(){

                public void postUndirectedEdgeAdded(NodeEvent e) {
                }

                public void postUndirectedEdgeRemoved(NodeEvent e) {
                }

                public void preUndirectedEdgeAdded(NodeEvent e) {
                }

                public void preUndirectedEdgeRemoved(NodeEvent e) {
                }

                public void transactionFinished(TransactionEvent e, BackgroundTaskStatusProviderSupportingExternalCall status) {
                }

                public void transactionStarted(TransactionEvent e) {
                }
            });
            es.getGraph().getListenerManager().addDelayedGraphListener(new GraphListener(){

                public void postEdgeAdded(GraphEvent e) {
                }

                public void postEdgeRemoved(GraphEvent e) {
                }

                public void postGraphCleared(GraphEvent e) {
                }

                public void postNodeAdded(GraphEvent e) {
                    AddonTab.cross2DS.add(new Cross2D(AttributeHelper.getPositionX((Node)e.getNode()), AttributeHelper.getPositionY((Node)e.getNode()), -5.0, 0.0, e.getNode().getID()));
                    rdg.getListenerManager().transactionFinished((Object)e);
                }

                public void postNodeRemoved(GraphEvent e) {
                    CreationKnotGraph.checkRenderButton();
                }

                public void preEdgeAdded(GraphEvent e) {
                    CreationKnotGraph.checkRenderButton();
                }

                public void preEdgeRemoved(GraphEvent e) {
                    CreationKnotGraph.checkRenderButton();
                }

                public void preGraphCleared(GraphEvent e) {
                    CreationKnotGraph.checkRenderButton();
                }

                public void preNodeAdded(GraphEvent e) {
                    CreationKnotGraph.checkRenderButton();
                }

                public void preNodeRemoved(GraphEvent e) {
                    CreationKnotGraph.checkRenderButton();
                }

                public void transactionFinished(TransactionEvent e, BackgroundTaskStatusProviderSupportingExternalCall status) {
                    CreationKnotGraph.checkRenderButton();
                }

                public void transactionStarted(TransactionEvent e) {
                    CreationKnotGraph.checkRenderButton();
                }
            });
            es.getGraph().getListenerManager().addDelayedGraphListener(new GraphListener(){

                public void postEdgeAdded(GraphEvent e) {
                }

                public void postEdgeRemoved(GraphEvent e) {
                }

                public void postGraphCleared(GraphEvent e) {
                }

                public void postNodeAdded(GraphEvent e) {
                }

                public void postNodeRemoved(GraphEvent e) {
                }

                public void preEdgeAdded(GraphEvent e) {
                }

                public void preEdgeRemoved(GraphEvent e) {
                }

                public void preGraphCleared(GraphEvent e) {
                }

                public void preNodeAdded(GraphEvent e) {
                }

                public void preNodeRemoved(GraphEvent e) {
                }

                public void transactionFinished(TransactionEvent e, BackgroundTaskStatusProviderSupportingExternalCall status) {
                    if (e.toString().contains("GraphElementsDeletionEdit")) {
                        Edge remEdge = null;
                        SplineGraph.splines = new ArrayList();
                        for (Edge edge : removedEdge) {
                            if (es.getGraph().getEdges().contains(edge)) continue;
                            remEdge = edge;
                        }
                        if (remEdge != null) {
                            Node n1 = remEdge.getTarget();
                            Node node = remEdge.getSource();
                        }
                    }
                }

                public void transactionStarted(TransactionEvent e) {
                    if (e.toString().contains("GraphElementsDeletionEdit")) {
                        removedEdge = new ArrayList<Edge>(es.getGraph().getEdges());
                    }
                }
            });
            es.getGraph().getListenerManager().addDelayedNodeListener(new NodeListener(){

                public void postUndirectedEdgeAdded(NodeEvent e) {
                }

                public void postUndirectedEdgeRemoved(NodeEvent e) {
                }

                public void preUndirectedEdgeAdded(NodeEvent e) {
                }

                public void preUndirectedEdgeRemoved(NodeEvent e) {
                }

                public void transactionFinished(TransactionEvent e, BackgroundTaskStatusProviderSupportingExternalCall status) {
                }

                public void transactionStarted(TransactionEvent e) {
                    try {
                        if (AddonTab.isCelticGraph()) {
                            AddonTab.remodel();
                        } else {
                            SplineGraph.splines = new ArrayList();
                        }
                    }
                    catch (Exception f) {
                        f.printStackTrace();
                    }
                }
            });
            AddonTab.executed = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Graph createGraph(ArrayList<String> nodes, ArrayList<String> edges) {
        rdg = new AdjListGraph();
        rdg.getListenerManager().transactionStarted((Object)rdg);
        try {
            int i;
            ArrayList<Node> nodes1 = new ArrayList<Node>();
            for (i = 0; i < nodes.size(); ++i) {
                String[] posString = nodes.get(i).split(",");
                Vector2d pos = new Vector2d(Double.parseDouble(posString[1]), Double.parseDouble(posString[2]));
                Node n = rdg.addNode(AttributeHelper.getDefaultGraphicsAttributeForNode((Vector2d)pos));
                n.setID(Long.parseLong(posString[0]));
                AttributeHelper.setShapeEllipse((Node)n);
                nodes1.add(n);
                AttributeHelper.setLabel((Node)n, (String)("" + (i + 1)));
            }
            for (i = 0; i < edges.size(); ++i) {
                String[] sp = edges.get(i).split(",");
                int source = Integer.parseInt(sp[1]);
                int target = Integer.parseInt(sp[2]);
                Node a = null;
                Node b = null;
                for (Node node : nodes1) {
                    if (node.getID() == (long)source) {
                        a = node;
                    }
                    if (node.getID() != (long)target) continue;
                    b = node;
                }
                try {
                    rdg.addEdge(a, b, false, AttributeHelper.getDefaultGraphicsAttributeForEdge((Color)Color.BLACK, (Color)Color.BLACK, (boolean)false));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            rdg.getListenerManager().transactionFinished((Object)rdg);
        }
        return rdg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Graph createGraph(int numberOfNodes) {
        rdg = new AdjListGraph();
        rdg.getListenerManager().transactionStarted((Object)rdg);
        try {
            int i;
            ArrayList<Node> nodes = new ArrayList<Node>();
            PositionGridGenerator pgg = new PositionGridGenerator(50.0, 50.0, 800.0);
            for (i = 0; i < numberOfNodes; ++i) {
                Node n = rdg.addNode(AttributeHelper.getDefaultGraphicsAttributeForNode((Vector2d)pgg.getNextPositionVec2d()));
                AttributeHelper.setShapeEllipse((Node)n);
                nodes.add(n);
                AttributeHelper.setLabel((Node)n, (String)("" + (i + 1)));
            }
            for (i = 0; i < numberOfNodes; ++i) {
                Node a = (Node)nodes.get(i);
                for (int j = 0; j < numberOfNodes; ++j) {
                    if (i == j || i > j) continue;
                    Node b = (Node)nodes.get(j);
                    rdg.addEdge(a, b, false, AttributeHelper.getDefaultGraphicsAttributeForEdge((Color)Color.BLACK, (Color)Color.BLACK, (boolean)false));
                }
            }
        }
        finally {
            rdg.getListenerManager().transactionFinished((Object)rdg);
        }
        return rdg;
    }

    public boolean isAlwaysExecutable() {
        return true;
    }

    public void createGraph() {
    }

    public static boolean hasError4reg() {
        for (Node n : rdg.getNodes()) {
            if (n.getDegree() == 4) continue;
            n.setID(0L);
            return true;
        }
        return false;
    }

    public static boolean hasErrorPlanar() {
        for (Edge edge : rdg.getEdges()) {
        }
        return false;
    }

    public static void fastRedraw1() {
        for (Node n : DrawKnotAlgorithm.interfaces.get(0).getOuterNodes()) {
            AttributeHelper.setFillColor((Attributable)n, (Color)Color.white);
        }
        ArrayList<ArrayList<Node>> matches = DrawKnotAlgorithm.interfaces.get(1).getMatchesRight(currentSelection1.size());
        if (matches.size() != 0 || !currentSelection1.isEmpty()) {
            // empty if block
        }
        int i = 0;
        for (ArrayList<Node> m : matches) {
            for (Node n : m) {
                if (i == 0) {
                    AttributeHelper.setFillColor((Attributable)n, (Color)Color.blue);
                }
                if (i == 1) {
                    AttributeHelper.setFillColor((Attributable)n, (Color)Color.green);
                }
                if (i != 2) continue;
                AttributeHelper.setFillColor((Attributable)n, (Color)Color.red);
            }
            ++i;
        }
        for (Node n : DrawKnotAlgorithm.interfaces.get(1).getOuterNodes()) {
            AttributeHelper.setFillColor((Attributable)n, (Color)Color.white);
        }
        for (Node n : currentSelection1) {
            AttributeHelper.setFillColor((Attributable)n, (Color)Color.green);
        }
        try {
            for (Node n : DrawKnotAlgorithm.interfaces.get(0).getMatchesLeft()) {
                AttributeHelper.setFillColor((Attributable)n, (Color)Color.gray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        removedEdge = new ArrayList<Edge>();
        indicatorEdges = new ArrayList();
        selectionMode = false;
        currentSelection1 = new ArrayList();
        currentSelection2 = new ArrayList();
        unionSelection1 = new ArrayList();
        unionSelection2 = new ArrayList();
        execButton = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                CreationKnotGraph.checkRenderButton();
            }
        };
        unionSelectingNodes = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CreationKnotGraph.checkRenderButton();
                double x = e.getX();
                double y = e.getY();
                double d = 20.0;
                if (selectionMode) {
                    extended = false;
                    boolean resetColors = false;
                    if (currentSelection1.isEmpty()) {
                        for (Node n : DrawKnotAlgorithm.interfaces.get(0).getOuterNodes()) {
                            CreationKnotGraph.extendSelection(x, y, d, n, currentSelection1);
                        }
                    } else if (currentSelection1.size() == 1) {
                        for (Node n : DrawKnotAlgorithm.interfaces.get(0).getOuterNodes()) {
                            CreationKnotGraph.extendSelection(x, y, d, n, currentSelection1);
                        }
                        if (!extended) {
                            CreationKnotGraph.deleteIndicatorEdges();
                            for (Node n : DrawKnotAlgorithm.interfaces.get(1).getOuterNodes()) {
                                currentSelection2 = CreationKnotGraph.getUnionSelection2(x, y, d, n);
                                if (currentSelection2 == null) continue;
                                CreationKnotGraph.deleteIndicatorEdges();
                                UnionOfInterfaces.unionOperation();
                                resetColors = true;
                            }
                        }
                    } else {
                        for (Node n : DrawKnotAlgorithm.interfaces.get(0).getOuterNodes()) {
                            CreationKnotGraph.extendSelection(x, y, d, n, currentSelection1);
                        }
                        if (!extended) {
                            currentSelection2 = null;
                            for (Edge e1 : indicatorEdges) {
                                if (CreationKnotGraph.getUnionSelectionEdge(x, y, d, e1) == null) continue;
                                currentSelection2 = CreationKnotGraph.getUnionSelectionEdge(x, y, d, e1);
                            }
                            if (currentSelection2 != null) {
                                CreationKnotGraph.deleteIndicatorEdges();
                                UnionOfInterfaces.unionOperation();
                                resetColors = true;
                            }
                        }
                    }
                    if (!resetColors) {
                        CreationKnotGraph.updateColors();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
    }
}

