/*
 * Decompiled with CFR 0.152.
 */
package org.vanted.addons.gknot;

import javax.swing.JPanel;
import org.Vector2d;

public class Cross2D
extends JPanel {
    private final double initialArmLength = 15.0;
    private double x;
    private double y;
    private boolean twoArms;
    private double rotation;
    private final long nodeId;
    private boolean top;
    private boolean bottom;
    private boolean right;
    private boolean left;
    private boolean topCircle;
    private boolean bottomCircle;
    private boolean leftCircle;
    private boolean rightCircle;
    private final double circleSize;
    private boolean hoveringTop;
    private boolean hoveringBottom;
    private boolean hoveringLeft;
    private boolean hoveringRight;
    private boolean hoveringCross;
    private boolean selectedCross;
    private boolean intersectArmRight;
    private boolean intersectArmTop;
    private boolean intersectArmBottom;
    private boolean isIntersectArmLeft;
    private boolean intersectRotPoint;
    private boolean intersectCross;
    int connectionTop;
    int connectionBottom;
    int connectionLeft;
    int connectionRight;

    public Cross2D(double x, double y, double armLength, double rotation, long nodeId) {
        this.x = x;
        this.y = y;
        this.rotation = rotation;
        this.nodeId = nodeId;
        this.top = false;
        this.bottom = false;
        this.right = false;
        this.left = false;
        this.topCircle = false;
        this.bottomCircle = false;
        this.rightCircle = false;
        this.leftCircle = false;
        this.circleSize = 8.0;
        this.hoveringTop = false;
        this.hoveringBottom = false;
        this.hoveringLeft = false;
        this.hoveringRight = false;
        this.hoveringCross = false;
        this.selectedCross = false;
        this.intersectCross = false;
        this.twoArms = false;
    }

    public boolean isTwoArms() {
        return this.twoArms;
    }

    public void setTwoArms(boolean b) {
        this.twoArms = b;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public Vector2d calcRot(double x1, double y1) {
        double xn = x1 - this.x;
        double yn = y1 - this.y;
        double x2 = Math.cos(Math.toRadians(this.rotation)) * xn + -1.0 * Math.sin(Math.toRadians(this.rotation)) * yn;
        double y2 = Math.sin(Math.toRadians(this.rotation)) * xn + Math.cos(Math.toRadians(this.rotation)) * yn;
        return new Vector2d(x2 + this.x, y2 + this.y);
    }

    public Vector2d getEndB() {
        return new Vector2d(this.calcRot((double)this.x, (double)(this.y + 15.0)).x, this.calcRot((double)this.x, (double)(this.y + 15.0)).y);
    }

    public Vector2d getEndL() {
        return new Vector2d(this.calcRot((double)(this.x - 15.0), (double)this.y).x, this.calcRot((double)(this.x - 15.0), (double)this.y).y);
    }

    public Vector2d getEndR() {
        return new Vector2d(this.calcRot((double)(this.x + 15.0), (double)this.y).x, this.calcRot((double)(this.x + 15.0), (double)this.y).y);
    }

    public Vector2d getEndT() {
        return new Vector2d(this.calcRot((double)this.x, (double)(this.y - 15.0)).x, this.calcRot((double)this.x, (double)(this.y - 15.0)).y);
    }

    public Vector2d getStartTB() {
        return new Vector2d(this.x, this.y);
    }

    public boolean getTop() {
        return this.top;
    }

    public boolean getBottom() {
        return this.bottom;
    }

    public boolean getRight() {
        return this.right;
    }

    public boolean getLeft() {
        return this.left;
    }

    public void setTop(boolean b) {
        this.top = b;
    }

    public void setBottom(boolean b) {
        this.bottom = b;
    }

    public void setRight(boolean b) {
        this.right = b;
    }

    public void setLeft(boolean b) {
        this.left = b;
    }

    public Vector2d getStartL() {
        return new Vector2d(this.calcRot((double)(this.x - 5.0), (double)this.y).x, this.calcRot((double)(this.x - 5.0), (double)this.y).y);
    }

    public Vector2d getStartR() {
        return new Vector2d(this.calcRot((double)(this.x + 5.0), (double)this.y).x, this.calcRot((double)(this.x + 5.0), (double)this.y).y);
    }

    public Vector2d getTopC() {
        double c = this.y - 15.0;
        return this.calcRot(this.x, c);
    }

    public Vector2d getLeftC() {
        double c = this.x - 15.0;
        return this.calcRot(c, this.y);
    }

    public Vector2d getRightC() {
        double c = this.x + 15.0;
        return this.calcRot(c, this.y);
    }

    public Vector2d getBottomC() {
        double c = this.y + 15.0;
        return this.calcRot(this.x, c);
    }

    public Vector2d getRotationPoint() {
        return this.calcRot(this.getStartTB().x + 10.0, this.getStartTB().y - 40.0);
    }

    public double getXC() {
        return this.calcRot((double)this.x, (double)this.y).x;
    }

    public double getYC() {
        return this.calcRot((double)this.x, (double)this.y).y;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void resetCrosses() {
        this.top = false;
        this.bottom = false;
        this.left = false;
        this.right = false;
    }

    public boolean topCircle() {
        return this.topCircle;
    }

    public boolean bottomCircle() {
        return this.bottomCircle;
    }

    public boolean leftCircle() {
        return this.leftCircle;
    }

    public boolean rightCircle() {
        return this.rightCircle;
    }

    public double getCircleSize() {
        return this.circleSize;
    }

    public void setTopCircle(boolean topCircle) {
        this.topCircle = topCircle;
    }

    public void setBottomCircle(boolean bottomCircle) {
        this.bottomCircle = bottomCircle;
    }

    public void setLeftCircle(boolean leftCircle) {
        this.leftCircle = leftCircle;
    }

    public void setRightCircle(boolean rightCircle) {
        this.rightCircle = rightCircle;
    }

    public boolean isHoveringTop() {
        return this.hoveringTop;
    }

    public boolean isHoveringBottom() {
        return this.hoveringBottom;
    }

    public boolean isHoveringLeft() {
        return this.hoveringLeft;
    }

    public boolean isHoveringRight() {
        return this.hoveringRight;
    }

    public void setHoveringTop(boolean hoveringTop) {
        this.hoveringTop = hoveringTop;
    }

    public void setHoveringBottom(boolean hoveringBottom) {
        this.hoveringBottom = hoveringBottom;
    }

    public void setHoveringLeft(boolean hoveringLeft) {
        this.hoveringLeft = hoveringLeft;
    }

    public void setHoveringRight(boolean hoveringRight) {
        this.hoveringRight = hoveringRight;
    }

    public void setHoveringCross(boolean hoveringCross) {
        this.hoveringCross = hoveringCross;
    }

    public boolean isHoveringCross() {
        return this.hoveringCross;
    }

    public void setSelectedCross(boolean selectedCross) {
        this.selectedCross = selectedCross;
    }

    public boolean isSelectedCross() {
        return this.selectedCross;
    }

    public void resetCircle() {
        this.topCircle = false;
        this.bottomCircle = false;
        this.leftCircle = false;
        this.rightCircle = false;
    }

    public void setIntersectArmRight(boolean intersectArmRight) {
        this.intersectArmRight = intersectArmRight;
    }

    public void setIntersectArmTop(boolean intersectArmTop) {
        this.intersectArmTop = intersectArmTop;
    }

    public void setIntersectArmBottom(boolean intersectArmBottom) {
        this.intersectArmBottom = intersectArmBottom;
    }

    public void setIntersectArmLeft(boolean intersectArmLeft) {
        this.isIntersectArmLeft = intersectArmLeft;
    }

    public void setIntersectRotPoint(boolean intersectRotPoint) {
        this.intersectRotPoint = intersectRotPoint;
    }

    public boolean isIntersectRotPoint() {
        return this.intersectRotPoint;
    }

    public void resetIntersection() {
        this.setIntersectArmRight(false);
        this.setIntersectArmLeft(false);
        this.setIntersectArmTop(false);
        this.setIntersectArmBottom(false);
        this.setIntersectRotPoint(false);
        this.setIntersectCross(false);
    }

    public double getXVal() {
        return this.x;
    }

    public double getYval() {
        return this.y;
    }

    public void setIntersectCross(boolean intersectCross) {
        this.intersectCross = intersectCross;
    }

    public boolean isIntersectCross() {
        return this.intersectCross;
    }

    public boolean isNotHovering() {
        return !this.isHoveringTop() && !this.isHoveringBottom() && !this.isHoveringLeft() && !this.isHoveringRight();
    }

    public void setConnectionTop(int connectionTop) {
        this.connectionTop = connectionTop;
    }

    public void setConnectionBottom(int connectionBottom) {
        this.connectionBottom = connectionBottom;
    }

    public void setConnectionLeft(int connectionLeft) {
        this.connectionLeft = connectionLeft;
    }

    public void setConnectionRight(int connectionRight) {
        this.connectionRight = connectionRight;
    }
}

