/*
 * Decompiled with CFR 0.152.
 */
package org.vanted.addons.gknot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import org.AttributeHelper;
import org.graffiti.editor.MainFrame;
import org.graffiti.graph.Edge;
import org.graffiti.graph.Graph;
import org.graffiti.graph.Node;
import org.graffiti.plugin.algorithm.AbstractAlgorithm;
import org.graffiti.plugin.view.View;
import org.graffiti.session.Session;
import org.vanted.addons.gknot.AddonTab;
import org.vanted.addons.gknot.AngleHelper;
import org.vanted.addons.gknot.CInterface;
import org.vanted.addons.gknot.ConvexHull;
import org.vanted.addons.gknot.CreationKnotGraph;
import org.vanted.addons.gknot.Cross2D;
import org.vanted.addons.gknot.PatternOperations;
import org.vanted.addons.gknot.RenderedView;
import org.vanted.addons.gknot.Spline;
import org.vanted.addons.gknot.SplineGraph;

public class DrawKnotAlgorithm
extends AbstractAlgorithm {
    AffineTransform affineTransformZoom = new AffineTransform();
    public static AffineTransform affineTransformTranslate = new AffineTransform();
    RenderedView r = AddonTab.r;
    public static SplineGraph splineGraph;
    public static ArrayList<AngleHelper> allAngles;
    Graph cache;
    public static ArrayList<CInterface> interfaces;
    public static ArrayList<Node> selection1;
    public static ArrayList<Node> selection2;
    public static ArrayList<String[]> ordering;

    public String getName() {
        return null;
    }

    public void execute() {
    }

    public void calculateKGV() {
        AngleHelper angleHelper;
        Graph editGraph = CreationKnotGraph.rdg;
        allAngles = new ArrayList();
        for (final Node n : editGraph.getNodes()) {
            angleHelper = new AngleHelper(n);
            double x = AttributeHelper.getPositionX((Node)n);
            double y = AttributeHelper.getPositionY((Node)n);
            Line2D.Double line1 = new Line2D.Double(x - 20.0, y, x + 20.0, y);
            ArrayList<Edge> edges = new ArrayList<Edge>();
            ArrayList<Double> angles = new ArrayList<Double>();
            Edge selfLoopEdge = null;
            boolean selfLoop = false;
            for (Edge e : editGraph.getEdges()) {
                double a;
                Line2D.Double line2;
                double y2;
                double x2;
                double y1;
                double x1;
                if (e.getSource() == n && e.getTarget() == n) {
                    selfLoop = true;
                    selfLoopEdge = e;
                    continue;
                }
                if (e.getSource() == n) {
                    edges.add(e);
                    x1 = AttributeHelper.getPositionX((Node)e.getSource());
                    y1 = AttributeHelper.getPositionY((Node)e.getSource());
                    x2 = AttributeHelper.getPositionX((Node)e.getTarget());
                    y2 = AttributeHelper.getPositionY((Node)e.getTarget());
                    line2 = new Line2D.Double(x1, y1, x2, y2);
                    a = this.calculateAngle(line2, line1);
                    angles.add(a);
                    continue;
                }
                if (e.getTarget() != n) continue;
                edges.add(e);
                x1 = AttributeHelper.getPositionX((Node)e.getTarget());
                y1 = AttributeHelper.getPositionY((Node)e.getTarget());
                x2 = AttributeHelper.getPositionX((Node)e.getSource());
                y2 = AttributeHelper.getPositionY((Node)e.getSource());
                line2 = new Line2D.Double(x1, y1, x2, y2);
                a = this.calculateAngle(line2, line1);
                angles.add(a);
            }
            ArrayList<Object> angleHelperVariables = new ArrayList<Object>();
            for (int i = 0; i < edges.size(); ++i) {
                double id = ((Edge)edges.get(i)).getSource() == n ? (double)((Edge)edges.get(i)).getTarget().getID() : (double)((Edge)edges.get(i)).getSource().getID();
                angleHelperVariables.add(new double[]{id, (Double)angles.get(i), ((Edge)edges.get(i)).getID()});
            }
            Comparator<double[]> comparator1 = new Comparator<double[]>(){

                @Override
                public int compare(double[] a, double[] b) {
                    if (a[1] == b[1]) {
                        if (a[0] > (double)n.getID()) {
                            return 1;
                        }
                        return -1;
                    }
                    return Double.compare(a[1], b[1]);
                }
            };
            angleHelperVariables.sort(comparator1.reversed());
            try {
                if (selfLoop) {
                    if (((double[])angleHelperVariables.get(0))[1] > ((double[])angleHelperVariables.get(1))[1]) {
                        angleHelper.setAngle3((double[])angleHelperVariables.get(0));
                        angleHelper.setAngle4((double[])angleHelperVariables.get(1));
                    } else {
                        angleHelper.setAngle4((double[])angleHelperVariables.get(0));
                        angleHelper.setAngle3((double[])angleHelperVariables.get(1));
                    }
                    angleHelper.setAngle1(new double[]{n.getID(), 0.0, selfLoopEdge.getID()});
                    angleHelper.setAngle2(new double[]{n.getID(), 0.0, selfLoopEdge.getID()});
                    angleHelper.setSelfLoop(true);
                } else {
                    angleHelper.setAngle1((double[])angleHelperVariables.get(0));
                    angleHelper.setAngle2((double[])angleHelperVariables.get(1));
                    angleHelper.setAngle3((double[])angleHelperVariables.get(2));
                    angleHelper.setAngle4((double[])angleHelperVariables.get(3));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            allAngles.add(angleHelper);
        }
        this.forceOrder(CreationKnotGraph.rdg);
        this.cache = (Graph)CreationKnotGraph.rdg.copy();
        for (Cross2D c : AddonTab.cross2DS) {
            angleHelper = this.searchAngeleHelper((int)c.getNodeId());
            if (angleHelper.isSelfLoop()) {
                c.setTwoArms(true);
                angleHelper.selfLoopOrder2();
            }
            try {
                c.setConnectionLeft((int)angleHelper.getAngle1()[0]);
                c.setConnectionTop((int)angleHelper.getAngle2()[0]);
                c.setConnectionRight((int)angleHelper.getAngle3()[0]);
                c.setConnectionBottom((int)angleHelper.getAngle4()[0]);
                c.setRotation(angleHelper.getAngeleAdjustment());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.generateSplines2();
        for (Spline spline : SplineGraph.splines) {
            spline.calcSpline();
        }
        ConvexHull.convexHull(CreationKnotGraph.rdg.getNodes().toArray(new Node[0]));
    }

    private void generateSplines2() {
        SplineGraph.splines = new ArrayList();
        ArrayList<Spline> splines = new ArrayList<Spline>();
        for (Edge e : CreationKnotGraph.rdg.getEdges()) {
            if (e.getSource() == e.getTarget()) continue;
            AngleHelper a = this.searchAngeleHelper((int)e.getSource().getID());
            AngleHelper b = this.searchAngeleHelper((int)e.getTarget().getID());
            Cross2D c = DrawKnotAlgorithm.searchCross((int)e.getSource().getID());
            Cross2D d = DrawKnotAlgorithm.searchCross((int)e.getTarget().getID());
            String aC = a.getCon(e.getID());
            String bC = b.getCon(e.getID());
            if (a.isSelfLoop() && b.isSelfLoop()) {
                splines.add(new Spline(new String[]{aC, bC}, c, d, e.getID()));
                continue;
            }
            if (a.isSelfLoop()) {
                splines.add(new Spline(new String[]{aC, bC}, c, d, e.getID()));
                continue;
            }
            if (b.isSelfLoop()) {
                splines.add(new Spline(new String[]{aC, bC}, c, d, e.getID()));
                continue;
            }
            splines.add(new Spline(new String[]{a.getCon(e.getID()), b.getCon(e.getID())}, c, d, e.getID()));
        }
        SplineGraph.splines = splines;
    }

    private Edge searchEdge(long eID) {
        for (Edge e : CreationKnotGraph.rdg.getEdges()) {
            if (e.getID() != eID) continue;
            return e;
        }
        return null;
    }

    private void forceOrder(Graph graph) {
        ordering = new ArrayList();
        ArrayList<AngleHelper> correctOrder = new ArrayList<AngleHelper>();
        for (Node n : graph.getNodes()) {
            if (!PatternOperations.containsSelfLoop(n)) continue;
            AngleHelper a = this.searchAngeleHelper((int)n.getID());
            a.setFinished(true);
            correctOrder.add(a);
            Cross2D c = DrawKnotAlgorithm.searchCross((int)n.getID());
            c.setTwoArms(true);
        }
        Node n = (Node)graph.getNodes().get(0);
        try {
            int i = 1;
            while (PatternOperations.containsSelfLoop(n)) {
                n = (Node)graph.getNodes().get(i);
                ++i;
            }
        }
        catch (Exception e) {
            return;
        }
        AngleHelper angleHelper = Objects.requireNonNull(this.searchAngeleHelper((int)n.getID()));
        correctOrder.add(angleHelper);
        String[] input = new String[]{String.valueOf(n.getID()), "L"};
        String[] loop = new String[2];
        boolean start = false;
        while (correctOrder.size() < graph.getNumberOfNodes()) {
            try {
                if (input[0].equalsIgnoreCase(loop[0]) && input[1].equalsIgnoreCase(loop[1]) && start) {
                    AngleHelper a = this.searchNonOrdered();
                    input = new String[]{String.valueOf(a.getN().getID()), "L"};
                    loop = (String[])input.clone();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (!start) {
                loop = (String[])input.clone();
                start = true;
            }
            ordering.add((String[])input.clone());
            input = this.orderNode(input);
            assert (input != null);
            angleHelper = this.searchAngeleHelper(Integer.parseInt(input[0]));
            if (correctOrder.contains(angleHelper)) continue;
            correctOrder.add(angleHelper);
        }
    }

    private AngleHelper searchNonOrdered() {
        for (AngleHelper angleHelper : allAngles) {
            if (angleHelper.isFinished()) continue;
            return angleHelper;
        }
        return null;
    }

    private String[] orderNode(String[] con1) {
        AngleHelper a = this.searchAngeleHelper(Integer.parseInt(con1[0]));
        switch (con1[1]) {
            case "L": {
                AngleHelper b = this.searchAngeleHelper((int)a.getAngle1()[0]);
                long e = (long)a.getAngle1()[2];
                String con2 = b.getCon(e);
                if (b.isSelfLoop()) {
                    String[] skip = this.skipSelfLoops(e, b);
                    b = this.searchAngeleHelper(Integer.parseInt(skip[1]));
                    con2 = skip[0];
                    e = Long.parseLong(skip[2]);
                }
                if (con2.equals("L") || con2.equals("R")) {
                    b.cycleOrder();
                    b.setFinished(true);
                    con2 = b.getCon(e);
                }
                if (con2.equals("T")) {
                    b.setFinished(true);
                    return new String[]{String.valueOf(b.getN().getID()), "B"};
                }
                b.setFinished(true);
                return new String[]{String.valueOf(b.getN().getID()), "T"};
            }
            case "T": {
                AngleHelper b = this.searchAngeleHelper((int)a.getAngle2()[0]);
                long e = (long)a.getAngle2()[2];
                String con2 = b.getCon(e);
                if (b.isSelfLoop()) {
                    String[] skip = this.skipSelfLoops(e, b);
                    b = this.searchAngeleHelper(Integer.parseInt(skip[1]));
                    con2 = skip[0];
                    e = Long.parseLong(skip[2]);
                }
                if (con2.equals("T") || con2.equals("B")) {
                    b.cycleOrder();
                    b.setFinished(true);
                    con2 = b.getCon(e);
                }
                if (con2.equals("L")) {
                    b.setFinished(true);
                    return new String[]{String.valueOf(b.getN().getID()), "R"};
                }
                b.setFinished(true);
                return new String[]{String.valueOf(b.getN().getID()), "L"};
            }
            case "R": {
                AngleHelper b = this.searchAngeleHelper((int)a.getAngle3()[0]);
                long e = (long)a.getAngle3()[2];
                String con2 = b.getCon(e);
                if (b.isSelfLoop()) {
                    String[] skip = this.skipSelfLoops(e, b);
                    b = this.searchAngeleHelper(Integer.parseInt(skip[1]));
                    con2 = skip[0];
                    e = Long.parseLong(skip[2]);
                }
                if (con2.equals("L") || con2.equals("R")) {
                    b.cycleOrder();
                    b.setFinished(true);
                    con2 = b.getCon(e);
                }
                if (con2.equals("T")) {
                    b.setFinished(true);
                    return new String[]{String.valueOf(b.getN().getID()), "B"};
                }
                b.setFinished(true);
                return new String[]{String.valueOf(b.getN().getID()), "T"};
            }
            case "B": {
                AngleHelper b = this.searchAngeleHelper((int)a.getAngle4()[0]);
                long e = (long)a.getAngle4()[2];
                String con2 = b.getCon(e);
                if (b.isSelfLoop()) {
                    String[] skip = this.skipSelfLoops(e, b);
                    b = this.searchAngeleHelper(Integer.parseInt(skip[1]));
                    con2 = skip[0];
                    e = Long.parseLong(skip[2]);
                }
                if (con2.equals("T") || con2.equals("B")) {
                    b.cycleOrder();
                    b.setFinished(true);
                    con2 = b.getCon(e);
                }
                if (con2.equals("L")) {
                    b.setFinished(true);
                    return new String[]{String.valueOf(b.getN().getID()), "R"};
                }
                b.setFinished(true);
                return new String[]{String.valueOf(b.getN().getID()), "L"};
            }
        }
        return null;
    }

    private String[] skipSelfLoops(long e, AngleHelper b) {
        String con2 = "";
        while (b.isSelfLoop()) {
            if (b.getAngle3()[2] == (double)e) {
                e = (long)b.getAngle4()[2];
                b = this.searchAngeleHelper((int)b.getAngle4()[0]);
                con2 = b.getCon(e);
                continue;
            }
            if (b.getAngle4()[2] == (double)e) {
                e = (long)b.getAngle3()[2];
                b = this.searchAngeleHelper((int)b.getAngle3()[0]);
                con2 = b.getCon(e);
                continue;
            }
            System.out.println("ERROR");
        }
        return new String[]{con2, String.valueOf(b.getN().getID()), String.valueOf(e)};
    }

    static boolean onSegment(Point2D p, Point2D q, Point2D r) {
        return q.getX() <= Math.max(p.getX(), r.getX()) && q.getX() >= Math.min(p.getX(), r.getX()) && q.getY() <= Math.max(p.getY(), r.getY()) && q.getY() >= Math.min(p.getY(), r.getY());
    }

    private static Point2D intersection(Line2D a, Line2D b) {
        double x1 = a.getX1();
        double y1 = a.getY1();
        double x2 = a.getX2();
        double y2 = a.getY2();
        double x3 = b.getX1();
        double y3 = b.getY1();
        double x4 = b.getX2();
        double y4 = b.getY2();
        double d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (d == 0.0) {
            return null;
        }
        double xi = ((x3 - x4) * (x1 * y2 - y1 * x2) - (x1 - x2) * (x3 * y4 - y3 * x4)) / d;
        double yi = ((y3 - y4) * (x1 * y2 - y1 * x2) - (y1 - y2) * (x3 * y4 - y3 * x4)) / d;
        return new Point2D.Double(xi, yi);
    }

    private Edge searchByNode(Node n1, Node n2) {
        for (Edge e : CreationKnotGraph.rdg.getEdges()) {
            if (e.getSource() == n1 && e.getTarget() == n2) {
                return e;
            }
            if (e.getTarget() != n1 || e.getSource() != n2) continue;
            return e;
        }
        return null;
    }

    public AngleHelper searchAngeleHelper(int n) {
        for (AngleHelper angleHelper : allAngles) {
            if ((int)angleHelper.getN().getID() != n) continue;
            return angleHelper;
        }
        return null;
    }

    private double calculateAngle(Line2D line2, Line2D line1) {
        double angle1 = Math.atan2(line1.getY2() - line1.getY1(), line1.getX2() - line1.getX1());
        double angle2 = Math.atan2(line2.getY2() - line2.getY1(), line2.getX2() - line2.getX1());
        return Math.toDegrees(angle1 - angle2);
    }

    public void reCalculate(JTextArea nodeText, JSlider sliderLength, JSlider sliderRotation, boolean all, boolean top, boolean bottom, boolean left, boolean right, boolean rotation) {
        Object selectionE = null;
        for (Node n : CreationKnotGraph.rdg.getNodes()) {
            boolean found = false;
            for (Cross2D cross : AddonTab.cross2DS) {
                if (cross.getNodeId() != n.getID()) continue;
                cross.setX(AttributeHelper.getPositionX((Node)n));
                cross.setY(AttributeHelper.getPositionY((Node)n));
                found = true;
            }
            if (found) continue;
            Cross2D cross2D = new Cross2D(AttributeHelper.getPositionX((Node)n), AttributeHelper.getPositionY((Node)n), 5.0, 0.0, n.getID());
            AddonTab.cross2DS.add(cross2D);
        }
        if (!this.findView()) {
            this.r = RenderedView.createInternalExemplaryView(CreationKnotGraph.es);
            this.r.setBackground(Color.white);
        }
        this.r.initComponents();
        this.r.panel.revalidate();
        this.r.panel.repaint();
    }

    public boolean findView() {
        for (Session mySession : MainFrame.getSessions()) {
            for (View myView : mySession.getViews()) {
                if (!myView.getViewName().equals("GKnot")) continue;
                return true;
            }
        }
        return false;
    }

    public void reCalcPos(double length, double rotation, boolean scale) {
        splineGraph = new SplineGraph(CreationKnotGraph.rdg.getNumberOfNodes());
        this.r.initComponents();
        this.r.panel.revalidate();
        this.r.panel.repaint();
    }

    public void initializeSplineGraph() {
        splineGraph = new SplineGraph(CreationKnotGraph.rdg.getNumberOfNodes());
        Graph editGraph = (Graph)CreationKnotGraph.es.getGraph().copy();
        for (Cross2D c : AddonTab.cross2DS) {
            List nodes = editGraph.getNodes();
            Node n1 = null;
            for (Node n : nodes) {
                if (n.getID() != c.getNodeId()) continue;
                n1 = n;
            }
            if (n1 == null) continue;
            for (Node n : n1.getNeighbors()) {
                Collection edges;
                Cross2D d = null;
                for (Cross2D i : AddonTab.cross2DS) {
                    if (n.getID() != i.getNodeId()) continue;
                    d = i;
                }
                if (d == null || (edges = editGraph.getEdges()).size() <= 0) continue;
                Edge toRemove = null;
                for (Edge e : edges) {
                    if ((e.getSource().getID() != n1.getID() || e.getTarget().getID() != n.getID()) && (e.getTarget().getID() != n1.getID() || e.getSource().getID() != n.getID())) continue;
                    toRemove = e;
                }
                edges.remove(toRemove);
            }
        }
    }

    public void paintComponent(Graphics2D g2, double xRel, double yRel, double zoomDiv) {
        if (RenderedView.zoom) {
            RenderedView.xOffset = zoomDiv * RenderedView.xOffset + (1.0 - zoomDiv) * xRel;
            RenderedView.yOffset = zoomDiv * RenderedView.yOffset + (1.0 - zoomDiv) * yRel;
            this.affineTransformZoom.setToTranslation(RenderedView.xOffset, RenderedView.yOffset);
            this.affineTransformZoom.setToScale(RenderedView.zoomFactor, RenderedView.zoomFactor);
            RenderedView.prevZoomFactor = RenderedView.zoomFactor;
            RenderedView.zoom = false;
        } else if (RenderedView.drag) {
            this.affineTransformZoom.setToTranslation(RenderedView.xOffset + (double)RenderedView.xDiff, RenderedView.yOffset + (double)RenderedView.yDiff);
            this.affineTransformZoom.setToScale(RenderedView.zoomFactor, RenderedView.zoomFactor);
            if (RenderedView.released) {
                RenderedView.xOffset += (double)RenderedView.xDiff;
                RenderedView.yOffset += (double)RenderedView.yDiff;
                RenderedView.drag = false;
            }
        }
        g2.transform(this.affineTransformZoom);
        g2.setStroke(new BasicStroke(1.5f));
        if (SplineGraph.splines != null) {
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke((float)AddonTab.sliderThickness.getValue() / 10.0f));
            for (Spline spline : SplineGraph.splines) {
                g2.setColor(Color.black);
                g2.draw(spline.getSpline());
            }
            g2.setColor(Color.BLACK);
        }
    }

    public static Cross2D searchCross(int i) {
        for (Cross2D c : AddonTab.cross2DS) {
            if (c.getNodeId() != (long)i) continue;
            return c;
        }
        return null;
    }

    static {
        interfaces = new ArrayList();
        selection1 = new ArrayList();
        selection2 = new ArrayList();
    }
}

