/*
 * Decompiled with CFR 0.152.
 */
package org.vanted.addons.gknot;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import org.vanted.addons.gknot.AngleHelper;
import org.vanted.addons.gknot.DrawKnotAlgorithm;
import org.vanted.addons.gknot.Spline;
import org.vanted.addons.gknot.SplineGraph;

public class IO {
    public static void exportToKGV() throws IOException {
        long[] con;
        long[] conStart;
        JFileChooser fileChooser = new JFileChooser();
        StringBuilder write = new StringBuilder();
        fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File(".kgv"));
        fileChooser.showSaveDialog(fileChooser);
        String fName = fileChooser.getSelectedFile().getAbsolutePath();
        FileWriter fileWriter = new FileWriter(fName);
        AngleHelper start = DrawKnotAlgorithm.allAngles.get(0);
        ArrayList<Long> exported = new ArrayList<Long>();
        ArrayList<String> exportCycle = new ArrayList<String>();
        if (start.isSelfLoop()) {
            conStart = new long[]{(long)start.getAngle3()[0], (long)start.getAngle3()[2]};
            exported.add(conStart[1]);
            con = new long[]{(long)start.getAngle3()[0], (long)start.getAngle3()[2]};
        } else {
            conStart = new long[]{(long)start.getAngle1()[0], (long)start.getAngle1()[2]};
            exported.add(conStart[1]);
            con = new long[]{(long)start.getAngle1()[0], (long)start.getAngle1()[2]};
        }
        Spline s = IO.searchForSpline(con[1]);
        IO.addExportCache(exportCycle, s, false);
        boolean switchSpline = false;
        long[] last = new long[]{};
        for (int i = 0; i < SplineGraph.splines.size(); ++i) {
            if (!switchSpline) {
                last = new long[]{s.getC().getNodeId(), s.getD().getNodeId()};
            } else {
                long cache = last[0];
                last[0] = last[1];
                last[1] = cache;
                switchSpline = false;
            }
            AngleHelper a = IO.searchForAngleHelper(con[0]);
            assert (a != null);
            con = IO.searchForConnection(a, con[1]);
            assert (con != null);
            if (exported.contains(con[1])) {
                while (exportCycle.size() > 5) {
                    fileWriter.write(exportCycle.get(2) + " " + exportCycle.get(3) + " " + exportCycle.get(4) + "\n");
                    exportCycle.remove(2);
                    exportCycle.remove(2);
                    exportCycle.remove(2);
                }
                fileWriter.write(exportCycle.get(2) + " " + exportCycle.get(0) + " " + exportCycle.get(1) + "\n");
                exportCycle = new ArrayList();
                con = IO.searchForNonExported(exported);
                if (con == null) break;
                fileWriter.write("*\n");
            }
            if ((s = IO.searchForSpline(con[1])) == null) break;
            long[] now = new long[]{s.getC().getNodeId(), s.getD().getNodeId()};
            exported.add(con[1]);
            if (last[1] == now[0]) {
                IO.addExportCache(exportCycle, s, false);
            } else {
                IO.addExportCache(exportCycle, s, true);
                switchSpline = true;
            }
            last = (long[])now.clone();
        }
        fileWriter.close();
    }

    private static void addExportCache(ArrayList<String> exportCycle, Spline s, boolean switchSpline) {
        if (!switchSpline) {
            System.out.println(s.getC().getNodeId());
            exportCycle.add("(" + s.getC().getStartTB().x + "," + s.getC().getStartTB().y + ")");
            exportCycle.add("(" + s.getX1() + "," + s.getY1() + ")");
            exportCycle.add("(" + s.getX2() + "," + s.getY2() + ")");
        } else {
            System.out.println(s.getD().getNodeId());
            exportCycle.add("(" + s.getD().getStartTB().x + "," + s.getD().getStartTB().y + ")");
            exportCycle.add("(" + s.getX2() + "," + s.getY2() + ")");
            exportCycle.add("(" + s.getX1() + "," + s.getY1() + ")");
        }
    }

    private static AngleHelper searchForAngleHelper(long iD) {
        for (AngleHelper a : DrawKnotAlgorithm.allAngles) {
            if (a.getiD() != iD) continue;
            return a;
        }
        return null;
    }

    private static long[] searchForConnection(AngleHelper a, long edgeID) {
        if (a.isSelfLoop()) {
            if (a.getAngle3()[2] == (double)edgeID) {
                return new long[]{(long)a.getAngle4()[0], (long)a.getAngle4()[2]};
            }
            if (a.getAngle4()[2] == (double)edgeID) {
                return new long[]{(long)a.getAngle3()[0], (long)a.getAngle3()[2]};
            }
        } else {
            if (a.getAngle1()[2] == (double)edgeID) {
                return new long[]{(long)a.getAngle3()[0], (long)a.getAngle3()[2]};
            }
            if (a.getAngle2()[2] == (double)edgeID) {
                return new long[]{(long)a.getAngle4()[0], (long)a.getAngle4()[2]};
            }
            if (a.getAngle3()[2] == (double)edgeID) {
                return new long[]{(long)a.getAngle1()[0], (long)a.getAngle1()[2]};
            }
            if (a.getAngle4()[2] == (double)edgeID) {
                return new long[]{(long)a.getAngle2()[0], (long)a.getAngle2()[2]};
            }
            System.out.println("ERROR: Connection not found!");
        }
        return null;
    }

    private static Spline searchForSpline(long iD) {
        for (Spline s : SplineGraph.splines) {
            if (s.getiD() != iD) continue;
            return s;
        }
        return null;
    }

    private static long[] searchForNonExported(ArrayList<Long> exported) {
        for (AngleHelper a : DrawKnotAlgorithm.allAngles) {
            if (!exported.contains((long)a.getAngle1()[2])) {
                return new long[]{(long)a.getAngle1()[0], (long)a.getAngle1()[2]};
            }
            if (!exported.contains((long)a.getAngle2()[2])) {
                return new long[]{(long)a.getAngle2()[0], (long)a.getAngle2()[2]};
            }
            if (!exported.contains((long)a.getAngle3()[2])) {
                return new long[]{(long)a.getAngle3()[0], (long)a.getAngle3()[2]};
            }
            if (exported.contains((long)a.getAngle4()[2])) continue;
            return new long[]{(long)a.getAngle4()[0], (long)a.getAngle4()[2]};
        }
        return null;
    }
}

