/*
 * Decompiled with CFR 0.152.
 */
package org.vanted.addons.gknot;

import de.ipk_gatersleben.ag_nw.graffiti.GraphHelper;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.AttributeHelper;
import org.Vector2d;
import org.graffiti.editor.MainFrame;
import org.graffiti.graph.Edge;
import org.graffiti.graph.Node;
import org.vanted.addons.gknot.AddonTab;
import org.vanted.addons.gknot.CInterface;
import org.vanted.addons.gknot.CreationKnotGraph;
import org.vanted.addons.gknot.DrawKnotAlgorithm;

public class PatternOperations {
    public static void rotateInterface() {
        if (CreationKnotGraph.currentSelection1.size() == 1) {
            Node n = CreationKnotGraph.currentSelection1.get(0);
            Node m = CreationKnotGraph.currentSelection2.get(0);
            Line2D.Double i1Line = new Line2D.Double(DrawKnotAlgorithm.interfaces.get((int)0).getCentroid().x, DrawKnotAlgorithm.interfaces.get((int)0).getCentroid().y, AttributeHelper.getPositionX((Node)n), AttributeHelper.getPositionY((Node)n));
            Line2D.Double i2Line = new Line2D.Double(DrawKnotAlgorithm.interfaces.get((int)1).getCentroid().x, DrawKnotAlgorithm.interfaces.get((int)1).getCentroid().y, AttributeHelper.getPositionX((Node)m), AttributeHelper.getPositionY((Node)m));
            Line2D.Double centroid1X = new Line2D.Double(DrawKnotAlgorithm.interfaces.get((int)0).getCentroid().x, DrawKnotAlgorithm.interfaces.get((int)0).getCentroid().y, DrawKnotAlgorithm.interfaces.get((int)0).getCentroid().x + 10.0, DrawKnotAlgorithm.interfaces.get((int)0).getCentroid().y);
            Line2D.Double centroid2X = new Line2D.Double(DrawKnotAlgorithm.interfaces.get((int)1).getCentroid().x, DrawKnotAlgorithm.interfaces.get((int)1).getCentroid().y, DrawKnotAlgorithm.interfaces.get((int)1).getCentroid().x - 10.0, DrawKnotAlgorithm.interfaces.get((int)1).getCentroid().y);
            double alpha1 = Math.toDegrees(PatternOperations.angleBetween2Lines(i1Line, centroid1X));
            double alpha2 = Math.toDegrees(PatternOperations.angleBetween2Lines(i2Line, centroid2X));
            double alpha = Math.toDegrees(PatternOperations.angleBetween2Lines(i1Line, i2Line));
            PatternOperations.rotateGraph(DrawKnotAlgorithm.interfaces.get(1), alpha);
        } else {
            Node n1 = CreationKnotGraph.currentSelection1.get(0);
            Node n2 = CreationKnotGraph.currentSelection1.get(1);
            Node m1 = CreationKnotGraph.currentSelection2.get(0);
            Node m2 = CreationKnotGraph.currentSelection2.get(1);
            Line2D.Double line1 = new Line2D.Double(AttributeHelper.getPositionX((Node)n1), AttributeHelper.getPositionY((Node)n1), AttributeHelper.getPositionX((Node)n2), AttributeHelper.getPositionY((Node)n2));
            Line2D.Double line2 = new Line2D.Double(AttributeHelper.getPositionX((Node)m1), AttributeHelper.getPositionY((Node)m1), AttributeHelper.getPositionX((Node)m2), AttributeHelper.getPositionY((Node)m2));
            double alpha = -(180.0 - Math.toDegrees(PatternOperations.angleBetween2Lines(line1, line2)));
            PatternOperations.rotateGraph(DrawKnotAlgorithm.interfaces.get(1), alpha);
        }
    }

    private static Line2D[] getAngleLines(Node n, CInterface cInterface) {
        Node a = PatternOperations.angleNodesRotation(n, cInterface)[0];
        Node b = PatternOperations.angleNodesRotation(n, cInterface)[1];
        double x0 = AttributeHelper.getPositionX((Node)n);
        double y0 = AttributeHelper.getPositionY((Node)n);
        double x1 = AttributeHelper.getPositionX((Node)a);
        double y1 = AttributeHelper.getPositionY((Node)a);
        double x2 = AttributeHelper.getPositionX((Node)b);
        double y2 = AttributeHelper.getPositionY((Node)b);
        Line2D.Double line1 = new Line2D.Double(x0, y0, x1, y1);
        Line2D.Double line2 = new Line2D.Double(x0, y0, x2, y2);
        return new Line2D[]{line1, line2};
    }

    public static boolean isLeftStructure(Line2D line, Vector2d c) {
        return (line.getX2() - line.getX1()) * (c.y - line.getY1()) - (line.getY2() - line.getY1()) * (c.x - line.getX1()) > 0.0;
    }

    private static Node[] angleNodesRotation(Node n, CInterface cInterface) {
        Node a = null;
        Node b = null;
        for (int i = 0; i < cInterface.getConvexHull().size(); ++i) {
            if (cInterface.getConvexHull().get(i) != n) continue;
            if (i == cInterface.getConvexHull().size() - 1) {
                a = cInterface.getConvexHull().get(i - 1);
                b = cInterface.getConvexHull().get(0);
                continue;
            }
            if (i == 0) {
                a = cInterface.getConvexHull().get(cInterface.getConvexHull().size() - 1);
                b = cInterface.getConvexHull().get(i + 1);
                continue;
            }
            a = cInterface.getConvexHull().get(i - 1);
            b = cInterface.getConvexHull().get(i + 1);
        }
        return new Node[]{a, b};
    }

    public static void rotateGraph(CInterface cInterface1, CInterface cInterface2, ArrayList<Node> selection, boolean first) {
        double alpha = 0.0;
        double phi = 0.0;
        Node n = selection.get(0);
        if (selection.size() == 1) {
            Node m = null;
            Node p = null;
            for (int i = 0; i < cInterface2.getConvexHull().size(); ++i) {
                if (cInterface2.getConvexHull().get(i) != n) continue;
                if (i == cInterface2.getConvexHull().size() - 1) {
                    m = cInterface2.getConvexHull().get(i - 1);
                    p = cInterface2.getConvexHull().get(0);
                    continue;
                }
                if (i == 0) {
                    m = cInterface2.getConvexHull().get(cInterface2.getConvexHull().size() - 1);
                    p = cInterface2.getConvexHull().get(i + 1);
                    continue;
                }
                m = cInterface2.getConvexHull().get(i - 1);
                p = cInterface2.getConvexHull().get(i + 1);
            }
            double x0 = AttributeHelper.getPositionX((Node)n);
            double y0 = AttributeHelper.getPositionY((Node)n);
            double x1 = AttributeHelper.getPositionX(m);
            double y1 = AttributeHelper.getPositionY(m);
            double x2 = AttributeHelper.getPositionX(p);
            double y2 = AttributeHelper.getPositionY(p);
            Line2D.Double line1 = new Line2D.Double(x0, y0, x1, y1);
            Line2D.Double line2 = new Line2D.Double(x0, y0, x2, y2);
            alpha = -Math.toDegrees(PatternOperations.angleBetween2Lines(line1, line2));
            Vector2d vector2d = PatternOperations.calcRot(AttributeHelper.getPositionX((Node)m), AttributeHelper.getPositionY((Node)m), AttributeHelper.getPositionX((Node)n), AttributeHelper.getPositionY((Node)n), alpha);
            Line2D.Double l2 = new Line2D.Double(vector2d.x, vector2d.y, AttributeHelper.getPositionX((Node)n), AttributeHelper.getPositionY((Node)n));
            Line2D.Double l1 = first ? new Line2D.Double(AttributeHelper.getPositionX((Node)n), AttributeHelper.getPositionY((Node)n), AttributeHelper.getPositionX((Node)n) + 10.0, AttributeHelper.getPositionY((Node)n)) : new Line2D.Double(AttributeHelper.getPositionX((Node)n), AttributeHelper.getPositionY((Node)n), AttributeHelper.getPositionX((Node)n) - 10.0, AttributeHelper.getPositionY((Node)n));
            phi = Math.toDegrees(PatternOperations.angleBetween2Lines(l1, l2));
        } else {
            Node m = selection.get(1);
            Line2D.Double l2 = new Line2D.Double(AttributeHelper.getPositionX((Node)n), AttributeHelper.getPositionY((Node)n), AttributeHelper.getPositionX((Node)m), AttributeHelper.getPositionY((Node)m));
            Line2D.Double l1 = new Line2D.Double(cInterface2.getCentroid().x, cInterface2.getCentroid().y, cInterface2.getCentroid().x + 10.0, cInterface2.getCentroid().y);
            phi = Math.toDegrees(PatternOperations.angleBetween2Lines(l1, l2));
        }
        PatternOperations.rotateGraph(cInterface2, phi);
    }

    private static void rotateGraph(CInterface cInterface, double phi2) {
        Vector2d newNodeCoordinates;
        for (Node m : cInterface.getOuterNodes()) {
            newNodeCoordinates = PatternOperations.calcRot(AttributeHelper.getPositionX((Node)m), AttributeHelper.getPositionY((Node)m), cInterface.getCentroid().x, cInterface.getCentroid().y, phi2);
            AttributeHelper.setPosition((Node)m, (double)newNodeCoordinates.x, (double)newNodeCoordinates.y);
        }
        for (Node m : cInterface.getInnerNodes()) {
            newNodeCoordinates = PatternOperations.calcRot(AttributeHelper.getPositionX((Node)m), AttributeHelper.getPositionY((Node)m), cInterface.getCentroid().x, cInterface.getCentroid().y, phi2);
            AttributeHelper.setPosition((Node)m, (double)newNodeCoordinates.x, (double)newNodeCoordinates.y);
        }
    }

    public static void translateGraph() {
        PatternOperations.translate();
        DrawKnotAlgorithm.interfaces.get(0).calculateCentroid();
        DrawKnotAlgorithm.interfaces.get(1).calculateCentroid();
        if (CreationKnotGraph.currentSelection1.size() > 1) {
            PatternOperations.checkFlip();
            PatternOperations.translate();
        } else {
            PatternOperations.checkFlip2();
            PatternOperations.translate();
        }
    }

    private static void checkFlip2() {
        Node n = CreationKnotGraph.currentSelection1.get(0);
        if (CreationKnotGraph.currentSelection1.size() == 1) {
            boolean bothRight;
            Node m = null;
            Node p = null;
            for (int i = 0; i < DrawKnotAlgorithm.interfaces.get(0).getConvexHull().size(); ++i) {
                if (DrawKnotAlgorithm.interfaces.get(0).getConvexHull().get(i) != n) continue;
                if (i == DrawKnotAlgorithm.interfaces.get(0).getConvexHull().size() - 1) {
                    m = DrawKnotAlgorithm.interfaces.get(0).getConvexHull().get(i - 1);
                    p = DrawKnotAlgorithm.interfaces.get(0).getConvexHull().get(0);
                    continue;
                }
                if (i == 0) {
                    m = DrawKnotAlgorithm.interfaces.get(0).getConvexHull().get(DrawKnotAlgorithm.interfaces.get(0).getConvexHull().size() - 1);
                    p = DrawKnotAlgorithm.interfaces.get(0).getConvexHull().get(i + 1);
                    continue;
                }
                m = DrawKnotAlgorithm.interfaces.get(0).getConvexHull().get(i - 1);
                p = DrawKnotAlgorithm.interfaces.get(0).getConvexHull().get(i + 1);
            }
            double x0 = AttributeHelper.getPositionX((Node)n);
            double y0 = AttributeHelper.getPositionY((Node)n);
            double x1 = AttributeHelper.getPositionX(m);
            double y1 = AttributeHelper.getPositionY(m);
            double x2 = AttributeHelper.getPositionX(p);
            double y2 = AttributeHelper.getPositionY(p);
            Line2D.Double line1 = new Line2D.Double(x0, y0, x1, y1);
            Line2D.Double line2 = new Line2D.Double(x0, y0, x2, y2);
            Point2D.Double intersection = new Point2D.Double(x0, y0);
            double perpendicularSlope = -1.0 / PatternOperations.getLineSlope(line1) * PatternOperations.getLineSlope(line2);
            Line2D perpendicularLine = PatternOperations.createPerpendicularLine(intersection, perpendicularSlope);
            Vector2d a = DrawKnotAlgorithm.interfaces.get(0).getCentroid();
            Vector2d b = DrawKnotAlgorithm.interfaces.get(1).getCentroid();
            boolean bothLeft = PatternOperations.isLeftStructure(perpendicularLine, a) && PatternOperations.isLeftStructure(perpendicularLine, b);
            boolean bl = bothRight = !PatternOperations.isLeftStructure(perpendicularLine, a) && !PatternOperations.isLeftStructure(perpendicularLine, b);
            if (bothLeft || bothRight) {
                PatternOperations.rotateGraph(DrawKnotAlgorithm.interfaces.get(1), 180.0);
            }
        }
    }

    public static double getLineSlope(Line2D line) {
        double x1 = line.getX1();
        double y1 = line.getY1();
        double x2 = line.getX2();
        double y2 = line.getY2();
        return (y2 - y1) / (x2 - x1);
    }

    public static Line2D createPerpendicularLine(Point2D intersection, double slope) {
        double x2 = intersection.getX() + 1.0;
        double y2 = intersection.getY() + slope;
        return new Line2D.Double(intersection.getX(), intersection.getY(), x2, y2);
    }

    private static void translate() {
        double min = Double.MAX_VALUE;
        Node n = null;
        for (Node node : CreationKnotGraph.currentSelection1) {
            if (!(AttributeHelper.getPositionX((Node)node) < min)) continue;
            min = AttributeHelper.getPositionX((Node)node);
            n = node;
        }
        min = Double.MAX_VALUE;
        Node m = null;
        for (Node p : CreationKnotGraph.currentSelection2) {
            if (!(AttributeHelper.getPositionX((Node)p) < min)) continue;
            min = AttributeHelper.getPositionX((Node)p);
            m = p;
        }
        double d = AttributeHelper.getPositionX(n);
        double y1 = AttributeHelper.getPositionY((Node)n);
        double x2 = AttributeHelper.getPositionX(m);
        double y2 = AttributeHelper.getPositionY(m);
        double distance1X = x2 - d;
        double distance1Y = y2 - y1;
        for (Node p : DrawKnotAlgorithm.interfaces.get(1).getOuterNodes()) {
            AttributeHelper.setPosition((Node)p, (double)(AttributeHelper.getPositionX((Node)p) - distance1X), (double)(AttributeHelper.getPositionY((Node)p) - distance1Y));
        }
        for (Node p : DrawKnotAlgorithm.interfaces.get(1).getInnerNodes()) {
            AttributeHelper.setPosition((Node)p, (double)(AttributeHelper.getPositionX((Node)p) - distance1X), (double)(AttributeHelper.getPositionY((Node)p) - distance1Y));
        }
    }

    private static void checkFlip() {
        boolean bothRight;
        Node n1 = CreationKnotGraph.currentSelection1.get(0);
        Node n2 = CreationKnotGraph.currentSelection1.get(1);
        Node m1 = CreationKnotGraph.currentSelection2.get(0);
        Node m2 = CreationKnotGraph.currentSelection2.get(1);
        Line2D.Double line1 = new Line2D.Double(AttributeHelper.getPositionX((Node)n1), AttributeHelper.getPositionY((Node)n1), AttributeHelper.getPositionX((Node)n2), AttributeHelper.getPositionY((Node)n2));
        Line2D.Double line2 = new Line2D.Double(AttributeHelper.getPositionX((Node)m1), AttributeHelper.getPositionY((Node)m1), AttributeHelper.getPositionX((Node)m2), AttributeHelper.getPositionY((Node)m2));
        DrawKnotAlgorithm.interfaces.get(0).calculateCentroid();
        DrawKnotAlgorithm.interfaces.get(1).calculateCentroid();
        Vector2d a = DrawKnotAlgorithm.interfaces.get(0).getCentroid();
        Vector2d b = DrawKnotAlgorithm.interfaces.get(1).getCentroid();
        boolean bothLeft = PatternOperations.isLeftStructure(line1, a) && PatternOperations.isLeftStructure(line1, b);
        boolean bl = bothRight = !PatternOperations.isLeftStructure(line1, a) && !PatternOperations.isLeftStructure(line1, b);
        if (bothLeft || bothRight) {
            PatternOperations.rotateGraph(DrawKnotAlgorithm.interfaces.get(1), 180.0);
        }
    }

    public static Vector2d calcRot(double x1, double y1, double x2, double y2, double rotation) {
        double xn = x1 - x2;
        double yn = y1 - y2;
        double x3 = Math.cos(Math.toRadians(rotation)) * xn + -1.0 * Math.sin(Math.toRadians(rotation)) * yn;
        double y3 = Math.sin(Math.toRadians(rotation)) * xn + Math.cos(Math.toRadians(rotation)) * yn;
        return new Vector2d(x3 + x2, y3 + y2);
    }

    public static void union(CInterface cInterface, ArrayList<Node[]> selection) {
        while (selection.size() > 0) {
            Node[] updateNodes = (Node[])selection.get(0).clone();
            selection.remove(0);
            cInterface.getOuterNodes().remove(updateNodes[1]);
            Edge keep1 = null;
            Edge keep2 = null;
            for (Edge e : updateNodes[1].getEdges()) {
                if (e.getSource() == updateNodes[0] || e.getTarget() == updateNodes[0]) continue;
                if (keep1 == null) {
                    keep1 = e;
                    continue;
                }
                if (keep2 != null) continue;
                keep2 = e;
            }
            assert (keep1 != null);
            if (keep1.getSource() == updateNodes[1]) {
                keep1.setSource(updateNodes[0]);
            } else {
                keep1.setTarget(updateNodes[0]);
            }
            assert (keep2 != null);
            if (keep2.getSource() == updateNodes[1]) {
                keep1.setSource(updateNodes[0]);
            } else {
                keep2.setTarget(updateNodes[0]);
            }
            CreationKnotGraph.rdg.getNodes().remove(updateNodes[1]);
        }
    }

    public static boolean scanForInterfaces() {
        PatternOperations.resetIds();
        ArrayList<Long> longs = new ArrayList<Long>();
        for (Node n : CreationKnotGraph.rdg.getNodes()) {
            longs.add(n.getID());
        }
        for (CInterface cInterface : DrawKnotAlgorithm.interfaces) {
            for (Node n : cInterface.getOuterNodes()) {
                longs.remove(n.getID());
            }
            for (Node n : cInterface.getInnerNodes()) {
                longs.remove(n.getID());
            }
        }
        int numberOfNewInterfaces = 0;
        while (!longs.isEmpty()) {
            Node n;
            n = PatternOperations.searchNode((Long)longs.get(0));
            List<Node> nodes = PatternOperations.getConnectedSubgraph(n);
            if (nodes.size() < 3) {
                return false;
            }
            DrawKnotAlgorithm.interfaces.add(new CInterface(nodes));
            ++numberOfNewInterfaces;
            for (Node m : nodes) {
                longs.remove(m.getID());
            }
        }
        MainFrame.showMessageDialog((String)(numberOfNewInterfaces + " Interfaces have been initialized."), (String)"Scan for Interfaces");
        return true;
    }

    public static Node searchNode(long id) {
        Node toReturn = null;
        for (Node n : CreationKnotGraph.rdg.getNodes()) {
            if (n.getID() != id) continue;
            toReturn = n;
            break;
        }
        return toReturn;
    }

    public static List<Node> getConnectedSubgraph(Node n) {
        ArrayList<Node> toReturn = new ArrayList<Node>();
        toReturn.add(n);
        ArrayList<Node> nodes = new ArrayList<Node>(n.getNeighbors());
        while (nodes.size() > 0) {
            n = (Node)nodes.get(0);
            nodes.remove(n);
            if (!toReturn.contains(n)) {
                toReturn.add(n);
            }
            for (Node m : n.getNeighbors()) {
                if (toReturn.contains(m) || nodes.contains(m)) continue;
                nodes.add(m);
            }
        }
        return toReturn;
    }

    public static double angleBetween2Lines(Line2D line1, Line2D line2) {
        double angle1 = Math.atan2(line1.getY1() - line1.getY2(), line1.getX1() - line1.getX2());
        double angle2 = Math.atan2(line2.getY1() - line2.getY2(), line2.getX1() - line2.getX2());
        return angle1 - angle2;
    }

    public static void scaleInterface() {
        CInterface cInterface = DrawKnotAlgorithm.interfaces.get(1);
        double distanceI1 = PatternOperations.getDistance(CreationKnotGraph.currentSelection1);
        double distanceI2 = PatternOperations.getDistance(CreationKnotGraph.currentSelection2);
        boolean b = false;
        while (distanceI1 > distanceI2) {
            b = true;
            cInterface.calculateCentroid();
            PatternOperations.scaleUpInterface(cInterface.getInnerNodes(), cInterface.getOuterNodes(), cInterface, true);
            distanceI2 = PatternOperations.getDistance(CreationKnotGraph.currentSelection2);
        }
        while (distanceI2 > distanceI1 && !b) {
            cInterface.calculateCentroid();
            PatternOperations.scaleUpInterface(cInterface.getInnerNodes(), cInterface.getOuterNodes(), cInterface, false);
            distanceI2 = PatternOperations.getDistance(CreationKnotGraph.currentSelection2);
        }
    }

    private static double getDistance(ArrayList<Node> selection) {
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        for (Node n : selection) {
            if (AttributeHelper.getPositionX((Node)n) < minX) {
                minX = AttributeHelper.getPositionX((Node)n);
            }
            if (!(AttributeHelper.getPositionX((Node)n) > maxX)) continue;
            maxX = AttributeHelper.getPositionX((Node)n);
        }
        return maxX - minX;
    }

    private static void scaleUpInterface(ArrayList<Node> innerNodes, ArrayList<Node> outerNodes, CInterface cInterface, boolean scaleUp) {
        double scalingFactor = 0.0;
        scalingFactor = scaleUp ? 1.01 : 0.99;
        PatternOperations.setNewPosition(innerNodes, cInterface, scalingFactor);
        PatternOperations.setNewPosition(outerNodes, cInterface, scalingFactor);
    }

    private static void setNewPosition(ArrayList<Node> innerNodes, CInterface cInterface, double scalingFactor) {
        for (Node n : innerNodes) {
            double cX = cInterface.getCentroid().x;
            double cY = cInterface.getCentroid().y;
            double nX = AttributeHelper.getPositionX((Node)n);
            double nY = AttributeHelper.getPositionY((Node)n);
            double vX = cX + (nX - cX) * scalingFactor;
            double vY = cY + (nY - cY) * scalingFactor;
            AttributeHelper.setPosition((Node)n, (double)vX, (double)vY);
        }
    }

    public static void mergeInterfaces() {
        for (Node n : CreationKnotGraph.currentSelection1) {
            PatternOperations.deleteSelfLoop(n);
        }
        for (Node n : CreationKnotGraph.currentSelection2) {
            PatternOperations.deleteSelfLoop(n);
        }
        ArrayList<long[]> linking = new ArrayList<long[]>();
        double borderX1 = -1.0;
        double borderX2 = -1.0;
        for (int i = 0; i < CreationKnotGraph.currentSelection1.size(); ++i) {
            double xVal;
            long[] link = new long[2];
            long currentMinID = -1L;
            double currentMinX = Double.MAX_VALUE;
            for (Node n : CreationKnotGraph.currentSelection1) {
                xVal = AttributeHelper.getPositionX((Node)n);
                if (!(xVal < currentMinX) || !(xVal > borderX1)) continue;
                currentMinX = xVal;
                currentMinID = n.getID();
            }
            borderX1 = currentMinX;
            link[0] = currentMinID;
            currentMinID = -1L;
            currentMinX = Double.MAX_VALUE;
            for (Node n : CreationKnotGraph.currentSelection2) {
                xVal = AttributeHelper.getPositionX((Node)n);
                if (!(xVal < currentMinX) || !(xVal > borderX2)) continue;
                currentMinX = xVal;
                currentMinID = n.getID();
            }
            borderX2 = currentMinX;
            link[1] = currentMinID;
            linking.add(link);
        }
        for (Node n : CreationKnotGraph.currentSelection2) {
            for (Edge e : n.getEdges()) {
                if (PatternOperations.getLink(e.getSource().getID(), linking) != -1L) {
                    e.setSource(PatternOperations.searchNode(PatternOperations.getLink(e.getSource().getID(), linking)));
                }
                if (PatternOperations.getLink(e.getTarget().getID(), linking) == -1L) continue;
                e.setTarget(PatternOperations.searchNode(PatternOperations.getLink(e.getTarget().getID(), linking)));
            }
        }
        for (Node n : CreationKnotGraph.currentSelection2) {
            CreationKnotGraph.rdg.deleteNode(n);
        }
        CreationKnotGraph.rdg.deleteAll(CreationKnotGraph.currentSelection2);
        PatternOperations.resetIds();
    }

    private static long getLink(long id, ArrayList<long[]> linking) {
        for (long[] links : linking) {
            if (links[1] != id) continue;
            return links[0];
        }
        return -1L;
    }

    public static void edgeContraction() {
        List edgeSelection = (List)GraphHelper.getSelectedOrAllEdges();
        List nodeSelection = GraphHelper.getSelectedOrAllNodes();
        if (edgeSelection.size() == 2 && nodeSelection.size() == 1) {
            Edge e1 = (Edge)edgeSelection.get(0);
            Edge e2 = (Edge)edgeSelection.get(1);
            Node n = (Node)nodeSelection.get(0);
            if (e1.getSource() == n && e2.getSource() == n) {
                Edge e = CreationKnotGraph.rdg.addEdge(e1.getTarget(), e2.getTarget(), false);
                AttributeHelper.setArrowhead((Edge)e, (boolean)false);
                CreationKnotGraph.rdg.deleteEdge(e1);
                CreationKnotGraph.rdg.deleteEdge(e2);
                if (n.getDegree() == 1) {
                    CreationKnotGraph.rdg.deleteNode(n);
                } else {
                    CreationKnotGraph.rdg.addEdge(n, n, true);
                }
            } else if (e1.getSource() == n && e2.getTarget() == n) {
                Edge e = CreationKnotGraph.rdg.addEdge(e1.getTarget(), e2.getSource(), false);
                AttributeHelper.setArrowhead((Edge)e, (boolean)false);
                CreationKnotGraph.rdg.deleteEdge(e1);
                CreationKnotGraph.rdg.deleteEdge(e2);
                if (n.getDegree() == 1) {
                    CreationKnotGraph.rdg.deleteNode(n);
                } else {
                    CreationKnotGraph.rdg.addEdge(n, n, true);
                }
            } else if (e1.getTarget() == n && e2.getTarget() == n) {
                Edge e3 = CreationKnotGraph.rdg.addEdge(e1.getSource(), e2.getSource(), false);
                AttributeHelper.setArrowhead((Edge)e3, (boolean)false);
                CreationKnotGraph.rdg.deleteEdge(e1);
                CreationKnotGraph.rdg.deleteEdge(e2);
                if (n.getDegree() == 1) {
                    CreationKnotGraph.rdg.deleteNode(n);
                } else {
                    CreationKnotGraph.rdg.addEdge(n, n, true);
                }
            } else if (e1.getTarget() == n && e2.getSource() == n) {
                Edge e3 = CreationKnotGraph.rdg.addEdge(e1.getSource(), e2.getTarget(), false);
                AttributeHelper.setArrowhead((Edge)e3, (boolean)false);
                CreationKnotGraph.rdg.deleteEdge(e1);
                CreationKnotGraph.rdg.deleteEdge(e2);
                if (n.getDegree() == 1) {
                    CreationKnotGraph.rdg.deleteNode(n);
                } else {
                    CreationKnotGraph.rdg.addEdge(n, n, true);
                }
            }
        } else {
            MainFrame.showMessageDialog((String)"The cut operation can only be performed on two edges, incident to the same node.", (String)"Operation Error.");
        }
        CreationKnotGraph.rdg.getNodes();
        AddonTab.remodel();
    }

    public static void edgeSplitting() {
        List edgeSelection = (List)GraphHelper.getSelectedOrAllEdges();
        List nodeSelection = GraphHelper.getSelectedOrAllNodes();
        if (edgeSelection.size() == 1 && nodeSelection.size() == 0) {
            Edge e = (Edge)edgeSelection.get(0);
            Node n1 = e.getSource();
            Node n2 = e.getTarget();
            Vector2d pos = new Vector2d(AttributeHelper.getPositionX((Node)n1) - 5.0, AttributeHelper.getPositionY((Node)n1) - 5.0);
            Node n = CreationKnotGraph.rdg.addNode(AttributeHelper.getDefaultGraphicsAttributeForNode((Vector2d)pos));
            AttributeHelper.setShapeEllipse((Node)n);
            Edge e1 = CreationKnotGraph.rdg.addEdge(n, n1, false);
            AttributeHelper.setArrowhead((Edge)e1, (boolean)false);
            Edge e2 = CreationKnotGraph.rdg.addEdge(n, n2, false);
            AttributeHelper.setArrowhead((Edge)e2, (boolean)false);
            Edge e3 = CreationKnotGraph.rdg.addEdge(n, n, true);
            AttributeHelper.setArrowhead((Edge)e3, (boolean)false);
            CreationKnotGraph.rdg.deleteEdge(e);
        } else if (edgeSelection.size() == 1 && nodeSelection.size() == 1) {
            Edge e = (Edge)edgeSelection.get(0);
            Node n1 = e.getSource();
            Node n2 = e.getTarget();
            Node n = (Node)nodeSelection.get(0);
            if (n.getDegree() == 3 && PatternOperations.containsSelfLoop(n)) {
                Edge e1 = CreationKnotGraph.rdg.addEdge(n1, n, false);
                AttributeHelper.setArrowhead((Edge)e1, (boolean)false);
                Edge e2 = CreationKnotGraph.rdg.addEdge(n2, n, false);
                AttributeHelper.setArrowhead((Edge)e2, (boolean)false);
                CreationKnotGraph.rdg.deleteEdge(e);
                PatternOperations.deleteSelfLoop(n);
            }
        } else {
            MainFrame.showMessageDialog((String)"The add operation can only be performed on either just one edge, or one edge and one node.", (String)"Operation Error.");
        }
        AddonTab.remodel();
        PatternOperations.resetIds();
    }

    public static void resetIds() {
        long id = 0L;
        for (Node n : CreationKnotGraph.rdg.getNodes()) {
            n.setID(id);
            ++id;
        }
    }

    public static boolean twoSelfLoops(Node n) {
        Edge e1 = (Edge)n.getEdges().toArray()[0];
        Edge e2 = (Edge)n.getEdges().toArray()[0];
        return e1.getSource() == e1.getTarget() && e2.getSource() == e2.getTarget();
    }

    public static boolean containsSelfLoop(Node n) {
        for (Edge e : n.getEdges()) {
            if (e.getSource() != e.getTarget()) continue;
            return true;
        }
        return false;
    }

    private static void deleteSelfLoop(Node n) {
        Edge e1 = null;
        for (Edge e : n.getEdges()) {
            if (e.getSource() != e.getTarget()) continue;
            e1 = e;
        }
        if (e1 != null) {
            CreationKnotGraph.rdg.deleteEdge(e1);
        }
    }

    public static boolean oneComponentGraph() {
        Node n = (Node)CreationKnotGraph.rdg.getNodes().get(0);
        return PatternOperations.getConnectedSubgraph(n).size() == CreationKnotGraph.rdg.getNodes().size();
    }
}

