/*
 * Decompiled with CFR 0.152.
 */
package org.vanted.addons.gknot;

import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import org.vanted.addons.gknot.BezierHandling;
import org.vanted.addons.gknot.Cross2D;

public class Spline {
    private long iD;
    private String[] con;
    private final Cross2D c;
    private final Cross2D d;
    private Path2D.Double spline = new Path2D.Double();
    private double x0;
    private double y0;
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private double x3;
    private double y3;
    private boolean twoArm;

    public Spline(String[] con, Cross2D c, Cross2D d, long iD) {
        this.c = c;
        this.con = con;
        this.d = d;
        this.iD = iD;
    }

    public long getiD() {
        return this.iD;
    }

    public void calcSpline() {
        if (this.c.isTwoArms()) {
            this.x0 = this.c.getStartTB().x;
            this.y0 = this.c.getStartTB().y;
            switch (this.con[0]) {
                case "T": {
                    this.x1 = this.c.getTopC().x;
                    this.y1 = this.c.getTopC().y;
                    break;
                }
                case "B": {
                    this.x1 = this.c.getBottomC().x;
                    this.y1 = this.c.getBottomC().y;
                    break;
                }
                case "L": {
                    this.x1 = this.c.getLeftC().x;
                    this.y1 = this.c.getLeftC().y;
                    break;
                }
                case "R": {
                    this.x1 = this.c.getRightC().x;
                    this.y1 = this.c.getRightC().y;
                }
            }
        } else {
            switch (this.con[0]) {
                case "T": {
                    this.x0 = this.c.getStartTB().x;
                    this.y0 = this.c.getStartTB().y;
                    this.x1 = this.c.getTopC().x;
                    this.y1 = this.c.getTopC().y;
                    break;
                }
                case "B": {
                    this.x0 = this.c.getStartTB().x;
                    this.y0 = this.c.getStartTB().y;
                    this.x1 = this.c.getBottomC().x;
                    this.y1 = this.c.getBottomC().y;
                    break;
                }
                case "L": {
                    this.x0 = this.c.getStartL().x;
                    this.y0 = this.c.getStartL().y;
                    this.x1 = this.c.getLeftC().x;
                    this.y1 = this.c.getLeftC().y;
                    break;
                }
                case "R": {
                    this.x0 = this.c.getStartR().x;
                    this.y0 = this.c.getStartR().y;
                    this.x1 = this.c.getRightC().x;
                    this.y1 = this.c.getRightC().y;
                }
            }
        }
        if (this.d.isTwoArms()) {
            this.x3 = this.d.getStartTB().x;
            this.y3 = this.d.getStartTB().y;
            switch (this.con[1]) {
                case "T": {
                    this.x2 = this.d.getTopC().x;
                    this.y2 = this.d.getTopC().y;
                    break;
                }
                case "B": {
                    this.x2 = this.d.getBottomC().x;
                    this.y2 = this.d.getBottomC().y;
                    break;
                }
                case "L": {
                    this.x2 = this.d.getLeftC().x;
                    this.y2 = this.d.getLeftC().y;
                    break;
                }
                case "R": {
                    this.x2 = this.d.getRightC().x;
                    this.y2 = this.d.getRightC().y;
                }
            }
        } else {
            switch (this.con[1]) {
                case "T": {
                    this.x2 = this.d.getTopC().x;
                    this.y2 = this.d.getTopC().y;
                    this.x3 = this.d.getStartTB().x;
                    this.y3 = this.d.getStartTB().y;
                    break;
                }
                case "B": {
                    this.x2 = this.d.getBottomC().x;
                    this.y2 = this.d.getBottomC().y;
                    this.x3 = this.d.getStartTB().x;
                    this.y3 = this.d.getStartTB().y;
                    break;
                }
                case "L": {
                    this.x2 = this.d.getLeftC().x;
                    this.y2 = this.d.getLeftC().y;
                    this.x3 = this.d.getStartL().x;
                    this.y3 = this.d.getStartL().y;
                    break;
                }
                case "R": {
                    this.x2 = this.d.getRightC().x;
                    this.y2 = this.d.getRightC().y;
                    this.x3 = this.d.getStartR().x;
                    this.y3 = this.d.getStartR().y;
                }
            }
        }
        this.calcArmLengthOptimal();
        this.spline = new Path2D.Double();
        this.spline.moveTo(this.x0, this.y0);
        this.spline.curveTo(this.x1, this.y1, this.x2, this.y2, this.x3, this.y3);
    }

    public Path2D.Double getSpline() {
        this.spline = new Path2D.Double();
        this.spline.moveTo(this.x0, this.y0);
        this.spline.curveTo(this.x1, this.y1, this.x2, this.y2, this.x3, this.y3);
        return this.spline;
    }

    public boolean isTwoArm() {
        return this.twoArm;
    }

    public void setTwoArm(boolean twoArm) {
        this.twoArm = twoArm;
    }

    public void calcAlpha() {
        double alphaInc = 0.1;
        double alphaMin = 0.1;
        double alphaMax = 1.0;
        double[] x = new double[4];
        double[] y = new double[4];
        double px1 = -1.0;
        double px2 = -1.0;
        double py1 = -1.0;
        double py2 = -1.0;
        switch (this.con[0]) {
            case "L": {
                x[0] = this.c.getStartL().x;
                y[0] = this.c.getStartL().y;
                px1 = this.c.getLeftC().x;
                py1 = this.c.getLeftC().y;
                break;
            }
            case "T": {
                x[0] = this.c.getStartTB().x;
                y[0] = this.c.getStartTB().y;
                px1 = this.c.getTopC().x;
                py1 = this.c.getTopC().y;
                break;
            }
            case "B": {
                x[0] = this.c.getStartTB().x;
                y[0] = this.c.getStartTB().y;
                px1 = this.c.getBottomC().x;
                py1 = this.c.getBottomC().y;
                break;
            }
            case "R": {
                x[0] = this.c.getStartR().x;
                y[0] = this.c.getStartR().y;
                px1 = this.c.getRightC().x;
                py1 = this.c.getRightC().y;
            }
        }
        switch (this.con[1]) {
            case "L": {
                if (this.d.isTwoArms()) {
                    x[3] = this.d.getStartTB().x;
                    y[3] = this.d.getStartTB().y;
                } else {
                    x[3] = this.d.getStartL().x;
                    y[3] = this.d.getStartL().y;
                }
                px2 = this.d.getLeftC().x;
                py2 = this.d.getLeftC().y;
                break;
            }
            case "T": {
                x[3] = this.d.getStartTB().x;
                y[3] = this.d.getStartTB().y;
                px2 = this.d.getTopC().x;
                py2 = this.d.getTopC().y;
                break;
            }
            case "B": {
                x[3] = this.d.getStartTB().x;
                y[3] = this.d.getStartTB().y;
                px2 = this.d.getBottomC().x;
                py2 = this.d.getBottomC().y;
                break;
            }
            case "R": {
                if (this.d.isTwoArms()) {
                    x[3] = this.d.getStartTB().x;
                    y[3] = this.d.getStartTB().y;
                } else {
                    x[3] = this.d.getStartR().x;
                    y[3] = this.d.getStartR().y;
                }
                px2 = this.d.getRightC().x;
                py2 = this.d.getRightC().y;
            }
        }
        double minMaxKappa = Double.MAX_VALUE;
        double alpha1MinMax = 0.0;
        double alpha2MinMax = 0.0;
        for (double alpha1 = alphaMin; alpha1 < alphaMax; alpha1 += alphaInc) {
            for (double alpha2 = alphaMin; alpha2 < alphaMax; alpha2 += alphaInc) {
                Spline.makeControlPoints(x, y, px1, py1, px2, py2, alpha1, alpha2);
                double maxKappa = Spline.getMaxKappa(x, y);
                if (!(minMaxKappa > maxKappa)) continue;
                minMaxKappa = maxKappa;
                alpha1MinMax = alpha1;
                alpha2MinMax = alpha2;
            }
        }
        Spline.makeControlPoints(x, y, px1, py1, px2, py2, alpha1MinMax, alpha2MinMax);
        this.x0 = x[0];
        this.y0 = y[0];
        this.x1 = x[1];
        this.y1 = y[1];
        this.x2 = x[2];
        this.y2 = y[2];
        this.x3 = x[3];
        this.y3 = y[3];
    }

    private static double bezierDot(double[] a, double t) {
        return a[0] * -3.0 * (1.0 - t) * (1.0 - t) + 3.0 * a[1] * (1.0 - 4.0 * t + 3.0 * t * t) + 3.0 * a[2] * (2.0 * t - 3.0 * t * t) + a[3] * 3.0 * t * t;
    }

    private static double bezier2Dot(double[] a, double t) {
        return a[0] * 6.0 * (1.0 - t) + 3.0 * a[1] * (-4.0 + 6.0 * t) + 3.0 * a[2] * (2.0 - 6.0 * t) + a[3] * 6.0 * t;
    }

    private static void makeControlPoints(double[] x, double[] y, double px1, double py1, double px2, double py2, double alpha1, double alpha2) {
        x[1] = (1.0 - alpha1) * x[0] + alpha1 * px1;
        y[1] = (1.0 - alpha1) * y[0] + alpha1 * py1;
        x[2] = (1.0 - alpha2) * x[3] + alpha2 * px2;
        y[2] = (1.0 - alpha2) * y[3] + alpha2 * py2;
    }

    private static double getMaxKappa(double[] x, double[] y) {
        double tInc = 0.01;
        double maxKappa = 0.0;
        for (double t = 0.0; t < 1.001; t += tInc) {
            double kappa = Spline.kappaBezier(x, y, t);
            maxKappa = Math.max(maxKappa, kappa);
        }
        return maxKappa;
    }

    private static double kappaBezier(double[] x, double[] y, double t) {
        double xD = Spline.bezierDot(x, t);
        double yD = Spline.bezierDot(y, t);
        double xDD = Spline.bezier2Dot(x, t);
        double yDD = Spline.bezier2Dot(y, t);
        double ss = xD * xD + yD * yD;
        double denom = ss * Math.sqrt(ss);
        double numer = Math.abs(xD * yDD - yD * xDD);
        if (Math.abs(denom) > 1.0E-7) {
            return numer / denom;
        }
        return 0.0;
    }

    public Cross2D getC() {
        return this.c;
    }

    public Cross2D getD() {
        return this.d;
    }

    public String[] getCon() {
        return this.con;
    }

    public void setCon(String[] con) {
        this.con = con;
    }

    public double getX0() {
        return this.x0;
    }

    public double getX1() {
        return this.x1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getX3() {
        return this.x3;
    }

    public double getY0() {
        return this.y0;
    }

    public double getY1() {
        return this.y1;
    }

    public double getY2() {
        return this.y2;
    }

    public double getY3() {
        return this.y3;
    }

    public void calcArmLengthOptimal() {
        Point2D[] points = new Point2D[]{new Point2D.Double(this.x0, this.y0), new Point2D.Double(this.x1, this.y1), new Point2D.Double(this.x2, this.y2), new Point2D.Double(this.x3, this.y3)};
        Point2D[] newPoints = BezierHandling.calculateMinimumCurvature(points);
        this.x1 = newPoints[1].getX();
        this.y1 = newPoints[1].getY();
        this.x2 = newPoints[2].getX();
        this.y2 = newPoints[2].getY();
    }

    public void setX1(double x1) {
        this.x1 = x1;
    }

    public void setY1(double y1) {
        this.y1 = y1;
    }

    public void setX2(double x2) {
        this.x2 = x2;
    }

    public void setY2(double y2) {
        this.y2 = y2;
    }
}

