/*
 * Decompiled with CFR 0.152.
 */
package org.vanted.addons.gknot;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JToolBar;
import org.ErrorMsg;
import org.graffiti.editor.MainFrame;
import org.graffiti.plugin.gui.GraffitiComponent;
import org.graffiti.plugin.view.View;
import org.graffiti.plugin.view.ViewListener;
import org.graffiti.session.EditorSession;
import org.graffiti.session.Session;
import org.graffiti.session.SessionListener;
import org.vanted.addons.gknot.WindowOrder;

public class ToolbarButton
extends JToolBar
implements GraffitiComponent,
SessionListener,
ViewListener {
    private static final long serialVersionUID = 1L;
    private JButton arrange;
    private String prefComp;
    private WindowOrder order;

    public ToolbarButton(String prefComp, WindowOrder order) {
        super("Arranging");
        this.prefComp = prefComp;
        this.order = order;
        this.arrange = new JButton(order.toString());
        this.arrange.setOpaque(false);
        this.arrange.setToolTipText("<html>Arranges windows.<br>Press Shift key and click here to restore minimized windows.<br>Press Ctrl key and click here to maximize the active window and to minimize all others.");
        this.setOpaque(false);
        double[][] size = new double[][]{{30.0}, {30.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])size));
        this.add((Component)this.arrange, "0,0");
        this.arrange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolbarButton.this.arrangeIt(actionEvent);
            }
        });
        this.validate();
    }

    public void sessionChanged(Session s) {
        if (s != null) {
            this.viewChanged(s.getActiveView());
        } else {
            this.arrange.setVisible(this.getVis());
        }
    }

    public void sessionDataChanged(Session s) {
        this.sessionChanged(s);
    }

    public void viewChanged(View newView) {
        if (newView != null) {
            this.arrange.setVisible(this.getVis());
        }
    }

    private boolean getVis() {
        switch (this.order) {
            case HORIZONTAL: {
                return MainFrame.getInstance().getDesktop().getAllFrames().length > 1;
            }
            case VERTICAL: {
                return MainFrame.getInstance().getDesktop().getAllFrames().length > 1;
            }
            case QUADRATIC: {
                return MainFrame.getInstance().getDesktop().getAllFrames().length > 2;
            }
        }
        return true;
    }

    public String getPreferredComponent() {
        return this.prefComp;
    }

    private void arrangeIt(ActionEvent actionEvent) {
        block11: for (EditorSession es : MainFrame.getEditorSessions()) {
            if (es.getGraph() == null) continue;
            if ((actionEvent.getModifiers() & 1) > 0) {
                this.restoreFrames();
            }
            if ((actionEvent.getModifiers() & 2) > 0) {
                this.iconizeFrames();
            }
            Dimension desktopdim = MainFrame.getInstance().getDesktop().getSize();
            int number = ToolbarButton.getOpenFrameCnt();
            int cnt = 0;
            if (number == 0) {
                number = 1;
            }
            switch (this.order) {
                case HORIZONTAL: {
                    for (JInternalFrame jf : MainFrame.getInstance().getDesktop().getAllFrames()) {
                        try {
                            jf.setMaximum(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        jf.setBounds(desktopdim.width * cnt++ / number, 0, desktopdim.width / number, desktopdim.height);
                    }
                    continue block11;
                }
                case VERTICAL: {
                    for (JInternalFrame jf : MainFrame.getInstance().getDesktop().getAllFrames()) {
                        try {
                            jf.setMaximum(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        jf.setBounds(0, desktopdim.height * cnt++ / number, desktopdim.width, desktopdim.height / number);
                    }
                    continue block11;
                }
                case QUADRATIC: {
                    int inRow = (int)Math.ceil(Math.sqrt(number));
                    int rows = (int)Math.ceil((double)number / (double)inRow);
                    int row = 0;
                    int col = 0;
                    for (JInternalFrame jf : MainFrame.getInstance().getDesktop().getAllFrames()) {
                        try {
                            jf.setMaximum(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        jf.setBounds(desktopdim.width * (col + 0) / inRow, (row + 0) * desktopdim.height / rows, desktopdim.width / inRow, desktopdim.height / rows);
                        if (++col < inRow) continue;
                        col = 0;
                        ++row;
                    }
                    break;
                }
            }
        }
    }

    private void iconizeFrames() {
        JInternalFrame self = MainFrame.getInstance().getDesktop().getSelectedFrame();
        if (self != null) {
            for (JInternalFrame jf : MainFrame.getInstance().getDesktop().getAllFrames()) {
                if (jf == self) continue;
                try {
                    jf.setIcon(true);
                }
                catch (PropertyVetoException e) {
                    ErrorMsg.addErrorMessage((Exception)e);
                }
            }
        }
    }

    private static int getOpenFrameCnt() {
        int res = 0;
        for (JInternalFrame jf : MainFrame.getInstance().getDesktop().getAllFrames()) {
            if (jf.isIcon()) continue;
            ++res;
        }
        return res;
    }

    private void restoreFrames() {
        JInternalFrame[] frames = MainFrame.getInstance().getDesktop().getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            try {
                frames[i].setMaximum(false);
                frames[i].setIcon(false);
                continue;
            }
            catch (PropertyVetoException e) {
                ErrorMsg.addErrorMessage((Exception)e);
            }
        }
    }

    public static void setArrangement() {
        Dimension desktopdim = MainFrame.getInstance().getDesktop().getSize();
        int number = ToolbarButton.getOpenFrameCnt();
        int cnt = 0;
        if (number == 0) {
            number = 1;
        }
        for (JInternalFrame jf : MainFrame.getInstance().getDesktop().getAllFrames()) {
            try {
                jf.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            jf.setBounds(desktopdim.width * cnt++ / number, 0, desktopdim.width / number, desktopdim.height);
        }
    }
}

